/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixGradleVersionInWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class Gradle4AndPlugin2Dot2ErrorHandler
extends SyncErrorHandler {
    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        if (Gradle4AndPlugin2Dot2ErrorHandler.isGradleAndPluginMismatch(this.getRootCause((Throwable)error), project)) {
            final String migrationDocUrl = "https://goo.gl/sEn5eA";
            notification.setListener(migrationDocUrl, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    BrowserUtil.browse((String)migrationDocUrl);
                }
            });
            NotificationHyperlink fixGradleVersion = FixGradleVersionInWrapperHyperlink.createIfProjectUsesGradleWrapper(project, "3.5");
            String text = "The versions of the Android Gradle plugin and Gradle are not compatible.\nPlease do one of the following:<ul><li>Update your plugin to version 2.4. This will require changes to build.gradle due to API changes.\n<a href='" + migrationDocUrl + "'>Open migration guide</a></li><li>Downgrade Gradle to version 3.5.";
            if (fixGradleVersion != null) {
                text = text + "\n" + fixGradleVersion.toHtml();
            }
            text = text + "</li></ul>";
            notification.setTitle("Gradle Sync Issues");
            notification.setMessage(text);
            notification.setNotificationCategory(NotificationCategory.convert((NotificationType)DEFAULT_NOTIFICATION_TYPE));
            List<NotificationHyperlink> quickFixes = Collections.emptyList();
            if (fixGradleVersion != null) {
                quickFixes = Collections.singletonList(fixGradleVersion);
            }
            GradleSyncMessages.getInstance(project).addNotificationListener(notification, quickFixes);
            return true;
        }
        return false;
    }

    private static boolean isGradleAndPluginMismatch(@NotNull Throwable rootCause, @NotNull Project project) {
        String text;
        boolean targetMissingMethodFound;
        if (rootCause instanceof NoSuchMethodError && (targetMissingMethodFound = (text = rootCause.getMessage()).startsWith("com.android.build.gradle.tasks.factory.AndroidJavaCompile.setDependencyCacheDir"))) {
            GradleWrapper gradleWrapper = GradleWrapper.find(project);
            if (gradleWrapper != null) {
                try {
                    String version = gradleWrapper.getGradleVersion();
                    if (version != null) {
                        GradleVersion parsed = GradleVersion.parse((String)version);
                        return parsed.compareIgnoringQualifiers("4.0") >= 0;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }
}

