/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GradleBrokenPipeErrorHandler
extends BaseSyncErrorHandler {
    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)text) && GradleBrokenPipeErrorHandler.getFirstLineMessage(text).startsWith("Broken pipe")) {
            GradleBrokenPipeErrorHandler.updateUsageTracker();
            text = "Broken pipe.\nThe Gradle daemon may be trying to use ipv4 instead of ipv6.";
            return text;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(new OpenUrlHyperlink("https://developer.android.com/r/studio-ui/known-issues.html", "More info (including workarounds)"));
        return hyperlinks;
    }
}

