/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaHeapSpaceErrorHandler
extends BaseSyncErrorHandler {
    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text = rootCause.getMessage();
        List<String> message = JavaHeapSpaceErrorHandler.getMessageLines(text);
        int lineCount = message.size();
        if (lineCount == 0) {
            return null;
        }
        String firstLine = message.get(0);
        String newMsg = null;
        if (StringUtil.isNotEmpty((String)firstLine) && firstLine.endsWith("Java heap space")) {
            newMsg = firstLine + ".";
        } else if (StringUtil.isNotEmpty((String)firstLine) && lineCount > 1 && firstLine.startsWith("Unable to start the daemon process")) {
            String cause = null;
            for (int i = 1; i < lineCount; ++i) {
                String line = message.get(i);
                if (!"Error occurred during initialization of VM".equals(line) || i >= lineCount - 1) continue;
                cause = message.get(i + 1);
                break;
            }
            if (cause != null && cause.startsWith("Could not reserve enough space for object heap")) {
                firstLine = StringUtil.trimEnd((String)firstLine, (String)".");
                if (!cause.endsWith(".")) {
                    cause = cause + ".";
                }
                newMsg = firstLine + ": " + StringUtil.decapitalize((String)cause);
            }
        }
        if (StringUtil.isNotEmpty(newMsg)) {
            newMsg = newMsg + "\nPlease assign more memory to Gradle in the project's gradle.properties file.\nFor example, the following line, in the gradle.properties file, sets the maximum Java heap size to 1,024 MB:\n<em>org.gradle.jvmargs=-Xmx1024m</em>";
            if (rootCause instanceof OutOfMemoryError) {
                newMsg = "Out of memory: " + newMsg;
                JavaHeapSpaceErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.OUT_OF_MEMORY);
            } else {
                JavaHeapSpaceErrorHandler.updateUsageTracker();
            }
            return newMsg;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(new OpenUrlHyperlink("http://www.gradle.org/docs/current/userguide/build_environment.html", "Read Gradle's configuration guide"));
        hyperlinks.add(new OpenUrlHyperlink("http://docs.oracle.com/javase/7/docs/technotes/guides/vm/gc-ergonomics.html", "Read about Java's heap size"));
        return hyperlinks;
    }
}

