/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallBuildToolsHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingBuildToolsErrorHandler
extends BaseSyncErrorHandler {
    private final Pattern MISSING_BUILD_TOOLS_PATTERN = Pattern.compile("(Cause: )?(F|f)ailed to find Build Tools revision (.*)");

    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)text)) {
            Matcher matcher = this.MISSING_BUILD_TOOLS_PATTERN.matcher(MissingBuildToolsErrorHandler.getFirstLineMessage(text));
            if ((rootCause instanceof IllegalStateException || rootCause instanceof ExternalSystemException) && matcher.matches()) {
                MissingBuildToolsErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.MISSING_BUILD_TOOLS);
                return text;
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        Matcher matcher = this.MISSING_BUILD_TOOLS_PATTERN.matcher(MissingBuildToolsErrorHandler.getFirstLineMessage(text));
        if (matcher.matches()) {
            String version = matcher.group(3);
            hyperlinks.add(new InstallBuildToolsHyperlink(version, null));
        }
        return hyperlinks;
    }
}

