/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallNdkHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingNdkErrorHandler
extends BaseSyncErrorHandler {
    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String message = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)message) && MissingNdkErrorHandler.isMatch(MissingNdkErrorHandler.getFirstLineMessage(message))) {
            MissingNdkErrorHandler.updateUsageTracker();
            return "NDK not configured.";
        }
        return null;
    }

    private static boolean isMatch(@NotNull String errorMessage) {
        return errorMessage.startsWith("NDK not configured.") || errorMessage.startsWith("NDK location not found.");
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        return Collections.singletonList(new InstallNdkHyperlink());
    }
}

