/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ToggleOfflineModeHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownHostErrorHandler
extends BaseSyncErrorHandler {
    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)text) && rootCause instanceof UnknownHostException) {
            UnknownHostErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.UNKNOWN_HOST);
            return String.format("Unknown host '%1$s'. You may need to adjust the proxy settings in Gradle.", text);
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        ToggleOfflineModeHyperlink enableOfflineMode = ToggleOfflineModeHyperlink.enableOfflineMode(project);
        if (enableOfflineMode != null) {
            hyperlinks.add(enableOfflineMode);
        }
        hyperlinks.add(new OpenUrlHyperlink("https://docs.gradle.org/current/userguide/userguide_single.html#sec:accessing_the_web_via_a_proxy", "Learn about configuring HTTP proxies in Gradle"));
        return hyperlinks;
    }
}

