/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.CreateGradleWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixGradleVersionInWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenGradleSettingsHyperlink;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class UnsupportedGradleVersionErrorHandler
extends BaseSyncErrorHandler {
    private static final Pattern UNSUPPORTED_GRADLE_VERSION_PATTERN_1 = Pattern.compile("Minimum supported Gradle version is (.*)\\. Current version is.*?");
    private static final Pattern UNSUPPORTED_GRADLE_VERSION_PATTERN_2 = Pattern.compile("Gradle version (.*) is required.*?");

    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text;
        String newMsg = "";
        if (UnsupportedGradleVersionErrorHandler.isOldGradleVersion(rootCause)) {
            newMsg = "The project is using an unsupported version of Gradle.\nPlease point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
        }
        if ((text = rootCause.getMessage()) != null && (UNSUPPORTED_GRADLE_VERSION_PATTERN_1.matcher(text).matches() || UNSUPPORTED_GRADLE_VERSION_PATTERN_2.matcher(text).matches())) {
            int i = text.indexOf("If using the gradle wrapper");
            if (i != -1) {
                text = text.substring(0, i);
                text = text.trim();
            }
            if (!text.endsWith(".")) {
                text = text + ".";
            }
            newMsg = text + "\n\n" + "Please fix the project's Gradle settings.";
        }
        if (StringUtil.isNotEmpty((String)newMsg)) {
            UnsupportedGradleVersionErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_GRADLE_VERSION);
            return newMsg;
        }
        return null;
    }

    private static boolean isOldGradleVersion(@NotNull Throwable error) {
        String msg = error.getMessage();
        if (error instanceof UnsupportedVersionException) {
            return true;
        }
        if (error instanceof UnsupportedMethodException && msg != null && msg.contains("GradleProject.getBuildScript")) {
            return true;
        }
        return error instanceof ClassNotFoundException && msg != null && msg.contains(ToolingModelBuilderRegistry.class.getName());
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        String gradleVersion = UnsupportedGradleVersionErrorHandler.getSupportedGradleVersion(UnsupportedGradleVersionErrorHandler.getFirstLineMessage(text));
        return UnsupportedGradleVersionErrorHandler.getQuickFixHyperlinksWithGradleVersion(project, gradleVersion);
    }

    @Nullable
    private static String getSupportedGradleVersion(@NotNull String message) {
        return UnsupportedGradleVersionErrorHandler.getSupportedGradleVersion(message, UNSUPPORTED_GRADLE_VERSION_PATTERN_1, UNSUPPORTED_GRADLE_VERSION_PATTERN_2);
    }

    @Nullable
    private static String getSupportedGradleVersion(@NotNull String message, Pattern ... patterns) {
        for (Pattern pattern : patterns) {
            String version;
            Matcher matcher = pattern.matcher(message);
            if (!matcher.matches() || !StringUtil.isNotEmpty((String)(version = matcher.group(1)))) continue;
            return version;
        }
        return null;
    }

    @NotNull
    public static List<NotificationHyperlink> getQuickFixHyperlinksWithGradleVersion(@NotNull Project project, @Nullable String gradleVersion) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        GradleWrapper gradleWrapper = GradleWrapper.find(project);
        if (gradleWrapper != null) {
            NotificationHyperlink hyperlink = FixGradleVersionInWrapperHyperlink.createIfProjectUsesGradleWrapper(project, gradleVersion);
            if (hyperlink != null) {
                hyperlinks.add(hyperlink);
            }
        } else {
            GradleProjectSettings gradleProjectSettings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
            if (gradleProjectSettings != null && gradleProjectSettings.getDistributionType() == DistributionType.LOCAL) {
                hyperlinks.add(new CreateGradleWrapperHyperlink());
            }
        }
        hyperlinks.add(new OpenGradleSettingsHyperlink());
        return hyperlinks;
    }
}

