/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UnsupportedModelVersionErrorHandler
extends BaseSyncErrorHandler {
    @NotNull
    public static final String UNSUPPORTED_MODEL_VERSION_ERROR_PREFIX = "The project is using an unsupported version of the Android Gradle plug-in";
    @NotNull
    public static final String READ_MIGRATION_GUIDE_MSG = "Please read the migration guide";

    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)text) && text.startsWith(UNSUPPORTED_MODEL_VERSION_ERROR_PREFIX)) {
            UnsupportedModelVersionErrorHandler.updateUsageTracker();
            return text;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(new FixAndroidGradlePluginVersionHyperlink());
        return hyperlinks;
    }
}

