/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.util.GoogleMavenRepository;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class AddGoogleMavenRepositoryHyperlink
extends NotificationHyperlink {
    @NotNull
    private final VirtualFile myBuildFile;
    private final boolean mySyncAfterFix;

    public AddGoogleMavenRepositoryHyperlink(@NotNull VirtualFile buildFile) {
        this(buildFile, true);
    }

    public AddGoogleMavenRepositoryHyperlink(@NotNull VirtualFile buildFile, boolean syncAfterFix) {
        super("add.google.maven.repository", AddGoogleMavenRepositoryHyperlink.getText(syncAfterFix));
        this.myBuildFile = buildFile;
        this.mySyncAfterFix = syncAfterFix;
    }

    @Override
    protected void execute(@NotNull Project project) {
        GradleBuildModel buildModel = GradleBuildModel.parseBuildFile(this.myBuildFile, project);
        GoogleMavenRepository.addGoogleRepository(buildModel.repositories(), project);
        WriteCommandAction.runWriteCommandAction((Project)project, buildModel::applyChanges);
        GradleBuildModel buildModelProject = GradleBuildModel.get(project);
        if (buildModelProject != null) {
            GoogleMavenRepository.addGoogleRepository(buildModelProject.buildscript().repositories(), project);
            WriteCommandAction.runWriteCommandAction((Project)project, buildModelProject::applyChanges);
        }
        if (this.mySyncAfterFix) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
        }
    }

    @NotNull
    private static String getText(boolean syncAfterFix) {
        String text = "Add Google Maven repository";
        if (syncAfterFix) {
            text = text + " and sync project";
        }
        return text;
    }

    @NotNull
    public VirtualFile getBuildFile() {
        return this.myBuildFile;
    }
}

