/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixAndroidGradlePluginVersionHyperlink
extends NotificationHyperlink {
    @NotNull
    private final GradleVersion myPluginVersion;
    @Nullable
    private final GradleVersion myGradleVersion;

    public FixAndroidGradlePluginVersionHyperlink() {
        this(GradleVersion.parse((String)AndroidPluginGeneration.ORIGINAL.getLatestKnownVersion()), GradleVersion.parse((String)"4.1"));
    }

    public FixAndroidGradlePluginVersionHyperlink(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion) {
        this("Upgrade plugin to version " + pluginVersion + " and sync project", pluginVersion, gradleVersion);
    }

    public FixAndroidGradlePluginVersionHyperlink(@NotNull String text, @NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion) {
        super("fixGradleElements", text);
        this.myPluginVersion = pluginVersion;
        this.myGradleVersion = gradleVersion;
    }

    @Override
    public void execute(@NotNull Project project) {
        AndroidPluginVersionUpdater updater = AndroidPluginVersionUpdater.getInstance(project);
        updater.updatePluginVersionAndSync(this.myPluginVersion, this.myGradleVersion, false);
    }

    @VisibleForTesting
    @NotNull
    public GradleVersion getPluginVersion() {
        return this.myPluginVersion;
    }

    @VisibleForTesting
    @Nullable
    public GradleVersion getGradleVersion() {
        return this.myGradleVersion;
    }
}

