/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class FixBuildToolsVersionHyperlink
extends NotificationHyperlink {
    @NotNull
    private final VirtualFile myBuildFile;
    @NotNull
    private final String myVersion;

    public FixBuildToolsVersionHyperlink(@NotNull VirtualFile buildFile, @NotNull String version) {
        super("fix.build.tools.version", "Update Build Tools version and sync project");
        this.myBuildFile = buildFile;
        this.myVersion = version;
    }

    @Override
    protected void execute(@NotNull Project project) {
        FixBuildToolsVersionHyperlink.setBuildToolsVersion(project, this.myBuildFile, this.myVersion, true);
    }

    static void setBuildToolsVersion(@NotNull Project project, @NotNull VirtualFile buildFile, @NotNull String version, boolean requestSync) {
        GradleBuildModel buildModel = GradleBuildModel.parseBuildFile(buildFile, project);
        AndroidModel android = buildModel.android();
        if (android == null) {
            return;
        }
        if (version.equals(android.buildToolsVersion().value())) {
            return;
        }
        android.setBuildToolsVersion(version);
        WriteCommandAction.runWriteCommandAction((Project)project, buildModel::applyChanges);
        if (requestSync) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
        }
    }
}

