/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.repository.Revision;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixBuildToolsVersionHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallBuildToolsHyperlink
extends NotificationHyperlink {
    @NotNull
    private final String myVersion;
    @Nullable
    private final VirtualFile myBuildFile;

    public InstallBuildToolsHyperlink(@NotNull String version, @Nullable VirtualFile buildFile) {
        super("install.build.tools", InstallBuildToolsHyperlink.getText(version, buildFile));
        this.myBuildFile = buildFile;
        this.myVersion = version;
    }

    @NotNull
    private static String getText(@NotNull String version, @Nullable VirtualFile buildFile) {
        String msg = String.format("Install Build Tools %1$s", version);
        msg = buildFile != null ? msg + ", update version in build file and sync project" : msg + " and sync project";
        return msg;
    }

    @Override
    protected void execute(@NotNull Project project) {
        ArrayList requested = Lists.newArrayList();
        Revision minBuildToolsRev = Revision.parseRevision((String)this.myVersion);
        requested.add(DetailsTypes.getBuildToolsPath((Revision)minBuildToolsRev));
        ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, requested);
        if (dialog != null && dialog.showAndGet()) {
            if (this.myBuildFile != null) {
                FixBuildToolsVersionHyperlink.setBuildToolsVersion(project, this.myBuildFile, this.myVersion, true);
            } else {
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
            }
        }
    }
}

