/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.ide.common.repository.SdkMavenRepository;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class InstallRepositoryHyperlink
extends NotificationHyperlink {
    @NotNull
    private final SdkMavenRepository myRepository;
    @NotNull
    private final String myDependency;

    public InstallRepositoryHyperlink(@NotNull SdkMavenRepository repository, @NotNull String dependency) {
        super("install.m2.repo", "Install Repository and sync project");
        this.myRepository = repository;
        this.myDependency = dependency;
    }

    @Override
    protected void execute(@NotNull Project project) {
        ArrayList requested = Lists.newArrayList();
        requested.add(this.myRepository.getPackageId());
        String noOpMessage = String.format("Could not find dependency \"%1$s\"", this.myDependency);
        ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, (Collection<String>)requested, noOpMessage);
        if (dialog != null) {
            dialog.setTitle("Install Missing Components");
            if (dialog.showAndGet()) {
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
            }
        }
    }

    @VisibleForTesting
    @NotNull
    public SdkMavenRepository getRepository() {
        return this.myRepository;
    }

    @VisibleForTesting
    @NotNull
    public String getDependency() {
        return this.myDependency;
    }
}

