/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.gradle.project.GradleProjectSyncData;
import com.android.tools.idea.gradle.project.sync.GradleSync;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.idea.ProjectSetUpTask;
import com.android.tools.idea.gradle.project.sync.idea.data.DataNodeCaches;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaGradleSync
implements GradleSync {
    private static final boolean SYNC_WITH_CACHED_MODEL_ONLY = SystemProperties.getBooleanProperty((String)"studio.sync.with.cached.model.only", (boolean)false);
    @NotNull
    private final Project myProject;

    public IdeaGradleSync(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    public void sync(@NotNull GradleSyncInvoker.Request request, @Nullable GradleSyncListener listener) {
        DataNodeCaches dataNodeCaches;
        DataNode<ProjectData> cache;
        GradleProjectSyncData syncData;
        this.myProject.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)true);
        boolean newProject = request.isNewOrImportedProject();
        if ((SYNC_WITH_CACHED_MODEL_ONLY || request.isUseCachedGradleModels()) && (syncData = GradleProjectSyncData.getInstance(this.myProject)) != null && syncData.canUseCachedProjectData() && (cache = (dataNodeCaches = DataNodeCaches.getInstance(this.myProject)).getCachedProjectData()) != null && !dataNodeCaches.isCacheMissingModels(cache)) {
            PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
            setupRequest.setUsingCachedGradleModels(true).setGenerateSourcesAfterSync(false).setLastSyncTimestamp(syncData.getLastGradleSyncTimestamp());
            IdeaGradleSync.setSkipAndroidPluginUpgrade(request, setupRequest);
            ProjectSetUpTask setUpTask = new ProjectSetUpTask(this.myProject, setupRequest, listener, newProject, true, true);
            setUpTask.onSuccess(cache);
            return;
        }
        PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
        setupRequest.setGenerateSourcesAfterSync(request.isGenerateSourcesOnSuccess()).setCleanProjectAfterSync(request.isCleanProject());
        IdeaGradleSync.setSkipAndroidPluginUpgrade(request, setupRequest);
        String externalProjectPath = Projects.getBaseDirPath(this.myProject).getPath();
        ProjectSetUpTask setUpTask = new ProjectSetUpTask(this.myProject, setupRequest, listener, newProject, newProject, false);
        ProgressExecutionMode executionMode = request.getProgressExecutionMode();
        ExternalSystemUtil.refreshProject((Project)this.myProject, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (String)externalProjectPath, (ExternalProjectRefreshCallback)setUpTask, (boolean)false, (ProgressExecutionMode)executionMode, (boolean)true);
    }

    private static void setSkipAndroidPluginUpgrade(@NotNull GradleSyncInvoker.Request syncRequest, @NotNull PostSyncProjectSetup.Request setupRequest) {
        if (ApplicationManager.getApplication().isUnitTestMode() && syncRequest.isSkipAndroidPluginUpgrade()) {
            setupRequest.setSkipAndroidPluginUpgrade();
        }
    }
}

