/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaSyncPopulateProjectTask {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PostSyncProjectSetup myProjectSetup;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final ProjectDataManager myDataManager;

    public IdeaSyncPopulateProjectTask(@NotNull Project project) {
        this(project, PostSyncProjectSetup.getInstance(project), GradleSyncState.getInstance(project), (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class));
    }

    @VisibleForTesting
    IdeaSyncPopulateProjectTask(@NotNull Project project, @NotNull PostSyncProjectSetup projectSetup, @NotNull GradleSyncState syncState, @NotNull ProjectDataManager dataManager) {
        this.myProject = project;
        this.myProjectSetup = projectSetup;
        this.mySyncState = syncState;
        this.myDataManager = dataManager;
    }

    public void populateProject(@NotNull DataNode<ProjectData> projectInfo) {
        this.populateProject(projectInfo, null, null, false);
    }

    public void populateProject(@NotNull DataNode<ProjectData> projectInfo, @Nullable PostSyncProjectSetup.Request setupRequest, @Nullable Runnable syncFinishedCallback, boolean allowModuleSelection) {
        Collection<DataNode<ModuleData>> activeModules = this.getActiveModules(projectInfo, allowModuleSelection);
        this.populateProject(projectInfo, activeModules, setupRequest, syncFinishedCallback);
    }

    @NotNull
    private Collection<DataNode<ModuleData>> getActiveModules(@NotNull DataNode<ProjectData> projectInfo, boolean allowModuleSelection) {
        Collection modules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        ProjectSubset subview = ProjectSubset.getInstance(this.myProject);
        if (!ApplicationManager.getApplication().isUnitTestMode() && ProjectSubset.getInstance(this.myProject).isFeatureEnabled() && modules.size() > 1) {
            if (allowModuleSelection) {
                Collection<DataNode<ModuleData>> selection = subview.showModuleSelectionDialog(modules);
                if (selection != null) {
                    return selection;
                }
            } else {
                int moduleCount;
                Object[] persistedModuleNames = subview.getSelection();
                if (persistedModuleNames != null && (moduleCount = persistedModuleNames.length) > 0) {
                    ArrayList moduleNames = Lists.newArrayList((Object[])persistedModuleNames);
                    ArrayList selectedModules = Lists.newArrayListWithExpectedSize((int)moduleCount);
                    for (DataNode module : modules) {
                        String name = ((ModuleData)module.getData()).getExternalName();
                        if (!moduleNames.contains(name)) continue;
                        selectedModules.add(module);
                    }
                    return selectedModules;
                }
            }
        }
        subview.clearSelection();
        return modules;
    }

    public void populateProject(@NotNull DataNode<ProjectData> projectInfo, @NotNull Collection<DataNode<ModuleData>> activeModules, @Nullable PostSyncProjectSetup.Request setupRequest) {
        this.populateProject(projectInfo, activeModules, setupRequest, null);
    }

    public void populateProject(final @NotNull DataNode<ProjectData> projectInfo, final @NotNull Collection<DataNode<ModuleData>> activeModules, final @Nullable PostSyncProjectSetup.Request setupRequest, final @Nullable Runnable syncFinishedCallback) {
        UIUtil.invokeAndWaitIfNeeded(() -> GradleSyncMessages.getInstance(this.myProject).removeProjectMessages());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.populate(projectInfo, activeModules, (ProgressIndicator)new EmptyProgressIndicator(), setupRequest, syncFinishedCallback);
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, "Project Setup", false){

            public void run(@NotNull ProgressIndicator indicator) {
                IdeaSyncPopulateProjectTask.this.populate((DataNode<ProjectData>)projectInfo, activeModules, indicator, setupRequest, syncFinishedCallback);
            }
        };
        task.queue();
    }

    private void populate(@NotNull DataNode<ProjectData> projectInfo, @NotNull Collection<DataNode<ModuleData>> activeModules, @NotNull ProgressIndicator indicator, @Nullable PostSyncProjectSetup.Request setupRequest, @Nullable Runnable syncFinishedCallback) {
        IdeaSyncPopulateProjectTask.disableExcludedModules(projectInfo, activeModules);
        this.doSelectiveImport(activeModules, this.myProject, setupRequest);
        if (syncFinishedCallback != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                syncFinishedCallback.run();
            } else {
                TransactionGuard.getInstance().submitTransactionLater((Disposable)this.myProject, syncFinishedCallback);
            }
        }
        if (setupRequest != null) {
            PostSyncProjectSetup.getInstance(this.myProject).setUpProject(setupRequest, indicator);
        }
    }

    private static void disableExcludedModules(@NotNull DataNode<ProjectData> projectInfo, @NotNull Collection<DataNode<ModuleData>> activeModules) {
        Collection allModules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        if (activeModules.size() != allModules.size()) {
            HashSet moduleToIgnore = Sets.newHashSet((Iterable)allModules);
            moduleToIgnore.removeAll(activeModules);
            for (DataNode moduleNode : moduleToIgnore) {
                ExternalSystemApiUtil.visit((DataNode)moduleNode, node -> node.setIgnored(true));
            }
        }
    }

    @VisibleForTesting
    void doSelectiveImport(@NotNull Collection<DataNode<ModuleData>> activeModules, @NotNull Project project, @Nullable PostSyncProjectSetup.Request setupRequest) {
        DataNode projectNode = activeModules.isEmpty() ? null : ExternalSystemApiUtil.findParent(activeModules.iterator().next(), (Key)ProjectKeys.PROJECT);
        try {
            if (projectNode != null) {
                Collection allModules = ExternalSystemApiUtil.findAll((DataNode)projectNode, (Key)ProjectKeys.MODULE);
                if (activeModules.size() != allModules.size()) {
                    THashSet moduleToIgnore = ContainerUtil.newIdentityTroveSet((Collection)allModules);
                    moduleToIgnore.removeAll(activeModules);
                    for (DataNode moduleNode : moduleToIgnore) {
                        ExternalSystemApiUtil.visit((DataNode)moduleNode, node -> node.setIgnored(true));
                    }
                }
                this.myDataManager.importData(projectNode, project, true);
            } else {
                this.myDataManager.importData(activeModules, project, true);
            }
        }
        catch (RuntimeException unexpected) {
            String message = ExceptionUtil.getRootCause((Throwable)unexpected).getMessage();
            Logger.getInstance(this.getClass()).warn("Sync failed: " + message, (Throwable)unexpected);
            if (setupRequest != null && setupRequest.isUsingCachedGradleModels()) {
                this.myProjectSetup.onCachedModelsSetupFailure(setupRequest);
                return;
            }
            this.mySyncState.syncFailed(message);
        }
    }
}

