/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.gradle.util.FilePaths;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

class ProjectFinder {
    ProjectFinder() {
    }

    @Nullable
    Project findProject(@NotNull ProjectResolverContext context) {
        String projectPath = context.getProjectPath();
        if (StringUtil.isNotEmpty((String)projectPath)) {
            Project[] projects;
            File projectDirPath = FilePaths.toSystemDependentPath(projectPath);
            for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                File currentPath;
                String basePath = project.getBasePath();
                if (basePath == null || !FileUtil.filesEqual((File)projectDirPath, (File)(currentPath = new File(basePath)))) continue;
                return project;
            }
        }
        return null;
    }
}

