/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.analytics.UsageTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectImportErrorHandler;

public class ProjectImportErrorHandler
extends AbstractProjectImportErrorHandler {
    private static final Pattern ERROR_LOCATION_PATTERN = Pattern.compile(".* file '(.*)'( line: ([\\d]+))?");

    @Nullable
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        Pair<String, Integer> pair;
        String errMessage;
        if (error instanceof ExternalSystemException) {
            this.logSyncFailure();
            return (ExternalSystemException)error;
        }
        Pair rootCauseAndLocation = this.getRootCauseAndLocation(error);
        Throwable rootCause = (Throwable)rootCauseAndLocation.getFirst();
        String location = (String)rootCauseAndLocation.getSecond();
        if (rootCause.getMessage() == null) {
            StringWriter writer = new StringWriter();
            rootCause.printStackTrace(new PrintWriter(writer));
            errMessage = writer.toString();
        } else {
            errMessage = rootCause.getMessage();
        }
        if (!errMessage.isEmpty() && Character.isLowerCase(errMessage.charAt(0))) {
            errMessage = "Cause: " + errMessage;
        }
        ExternalSystemException exception = null;
        if (StringUtil.isNotEmpty((String)location) && (pair = ProjectImportErrorHandler.getErrorLocation(location)) != null) {
            exception = new LocationAwareExternalSystemException(errMessage, (String)pair.first, (Integer)pair.getSecond(), new String[0]);
        }
        if (exception == null) {
            exception = new ExternalSystemException(errMessage);
        }
        exception.initCause(rootCause);
        return exception;
    }

    public void logSyncFailure() {
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
        event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE).setGradleSyncFailure(AndroidStudioEvent.GradleSyncFailure.UNKNOWN_GRADLE_FAILURE);
        UsageTracker.getInstance().log(event);
    }

    @Nullable
    public String getLocationFrom(@NotNull Throwable error) {
        String location;
        String errorToString = error.toString();
        if (errorToString.contains("LocationAwareException") && (location = error.getMessage()) != null && (location.startsWith("Build file '") || location.startsWith("Settings file '"))) {
            String[] lines = StringUtil.splitByLines((String)location);
            return lines.length > 0 ? lines[0] : null;
        }
        return null;
    }

    @NotNull
    public ExternalSystemException createUserFriendlyError(@NotNull String msg, @Nullable String location, String ... quickFixes) {
        Pair<String, Integer> pair;
        if (StringUtil.isNotEmpty((String)location) && (pair = ProjectImportErrorHandler.getErrorLocation(location)) != null) {
            return new LocationAwareExternalSystemException(msg, (String)pair.first, (Integer)pair.getSecond(), quickFixes);
        }
        return new ExternalSystemException(msg, null, quickFixes);
    }

    @VisibleForTesting
    @Nullable
    static Pair<String, Integer> getErrorLocation(@NotNull String location) {
        Matcher matcher = ERROR_LOCATION_PATTERN.matcher(location);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            int line = -1;
            String lineAsText = matcher.group(3);
            if (lineAsText != null) {
                try {
                    line = Integer.parseInt(lineAsText);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return Pair.create((Object)filePath, (Object)line);
        }
        return null;
    }
}

