/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.GradleProjectSyncData;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.idea.IdeaSyncPopulateProjectTask;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectSetUpTask
implements ExternalProjectRefreshCallback {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PostSyncProjectSetup.Request mySetupRequest;
    @Nullable
    private final GradleSyncListener mySyncListener;
    private final boolean myProjectIsNew;
    private final boolean mySelectModulesToImport;
    private final boolean mySyncSkipped;

    ProjectSetUpTask(@NotNull Project project, @NotNull PostSyncProjectSetup.Request setupRequest, @Nullable GradleSyncListener syncListener, boolean projectIsNew, boolean selectModulesToImport, boolean syncSkipped) {
        this.myProject = project;
        this.mySetupRequest = setupRequest;
        this.mySyncListener = syncListener;
        this.myProjectIsNew = projectIsNew;
        this.mySelectModulesToImport = selectModulesToImport;
        this.mySyncSkipped = syncSkipped;
    }

    public void onSuccess(@Nullable DataNode<ProjectData> projectInfo) {
        assert (projectInfo != null);
        if (this.mySyncListener != null) {
            this.mySyncListener.setupStarted(this.myProject);
        }
        GradleSyncState.getInstance(this.myProject).setupStarted();
        this.populateProject(projectInfo);
        Runnable runnable = () -> {
            boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
            if (!isTest || !GradleProjectImporter.ourSkipSetupFromTest) {
                if (this.myProjectIsNew) {
                    Projects.open(this.myProject);
                }
                if (!isTest) {
                    this.myProject.save();
                }
            }
            if (this.myProjectIsNew) {
                AndroidGradleProjectComponent projectComponent = AndroidGradleProjectComponent.getInstance(this.myProject);
                projectComponent.configureGradleProject();
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)this.myProject, runnable);
        }
    }

    private void populateProject(@NotNull DataNode<ProjectData> projectInfo) {
        if (!this.myProjectIsNew) {
            this.doPopulateProject(projectInfo);
            return;
        }
        StartupManager startupManager = StartupManager.getInstance((Project)this.myProject);
        startupManager.runWhenProjectIsInitialized(() -> this.doPopulateProject(projectInfo));
    }

    private void doPopulateProject(@NotNull DataNode<ProjectData> projectInfo) {
        IdeaSyncPopulateProjectTask task = new IdeaSyncPopulateProjectTask(this.myProject);
        task.populateProject(projectInfo, this.mySetupRequest, () -> {
            if (this.mySyncListener != null) {
                if (this.mySyncSkipped) {
                    this.mySyncListener.syncSkipped(this.myProject);
                } else {
                    this.mySyncListener.syncSucceeded(this.myProject);
                }
            }
        }, this.mySelectModulesToImport);
    }

    public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
        UIUtil.invokeAndWaitIfNeeded(() -> ExternalSystemUtil.ensureToolWindowContentInitialized((Project)this.myProject, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID));
        if (StringUtil.isNotEmpty((String)errorDetails)) {
            ProjectSetUpTask.getLogger().warn(errorDetails);
        }
        this.handleSyncFailure(errorMessage);
    }

    private void handleSyncFailure(@NotNull String errorMessage) {
        String newMessage = ExternalSystemBundle.message((String)"error.resolve.with.reason", (Object[])new Object[]{errorMessage});
        ProjectSetUpTask.getLogger().warn(newMessage);
        GradleProjectSyncData.removeFrom(this.myProject);
        GradleSyncState.getInstance(this.myProject).syncFailed(newMessage);
        if (this.mySyncListener != null) {
            this.mySyncListener.syncFailed(this.myProject, newMessage);
        }
        if (!this.myProject.isOpen()) {
            GradleProjectInfo.getInstance(this.myProject).setProjectCreationError(newMessage);
        }
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(ProjectSetUpTask.class);
    }
}

