/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class DataNodeCaches {
    @NotNull
    private final Project myProject;

    @NotNull
    public static DataNodeCaches getInstance(@NotNull Project project) {
        return (DataNodeCaches)ServiceManager.getService((Project)project, DataNodeCaches.class);
    }

    public DataNodeCaches(@NotNull Project project) {
        this.myProject = project;
    }

    @Nullable
    public DataNode<ProjectData> getCachedProjectData() {
        String projectPath;
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        ExternalProjectInfo projectInfo = dataManager.getExternalProjectData(this.myProject, GradleConstants.SYSTEM_ID, projectPath = Projects.getBaseDirPath(this.myProject).getPath());
        return projectInfo != null ? projectInfo.getExternalProjectStructure() : null;
    }

    public boolean isCacheMissingModels(@NotNull DataNode<ProjectData> cache) {
        Collection moduleDataNodes = ExternalSystemApiUtil.findAll(cache, (Key)ProjectKeys.MODULE);
        if (!moduleDataNodes.isEmpty()) {
            Map<String, DataNode<ModuleData>> moduleDataNodesByName = DataNodeCaches.indexByModuleName(moduleDataNodes);
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            for (Module module : moduleManager.getModules()) {
                GradleFacet gradleFacet;
                DataNode<ModuleData> moduleDataNode = moduleDataNodesByName.get(module.getName());
                if (!(moduleDataNode == null ? (gradleFacet = GradleFacet.getInstance(module)) != null : DataNodeCaches.isCacheMissingModels(moduleDataNode, module))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<String, DataNode<ModuleData>> indexByModuleName(@NotNull Collection<DataNode<ModuleData>> moduleDataNodes) {
        HashMap mapping = Maps.newHashMap();
        for (DataNode<ModuleData> moduleDataNode : moduleDataNodes) {
            ModuleData data = (ModuleData)moduleDataNode.getData();
            mapping.put(data.getExternalName(), moduleDataNode);
        }
        return mapping;
    }

    private static boolean isCacheMissingModels(@NotNull DataNode<ModuleData> cache, @NotNull Module module) {
        DataNode ndkModuleModelDataNode;
        NdkFacet ndkFacet;
        GradleFacet gradleFacet = GradleFacet.getInstance(module);
        if (gradleFacet != null) {
            DataNode javaProjectDataNode;
            JavaFacet javaFacet;
            DataNode androidDataNode;
            DataNode gradleDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.GRADLE_MODULE_MODEL);
            if (gradleDataNode == null) {
                return true;
            }
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet != null ? (androidDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.ANDROID_MODEL)) == null : (javaFacet = JavaFacet.getInstance(module)) != null && (javaProjectDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.JAVA_MODULE_MODEL)) == null) {
                return true;
            }
        }
        return (ndkFacet = NdkFacet.getInstance(module)) != null && (ndkModuleModelDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.NDK_MODEL)) == null;
    }
}

