/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.ArtifactsByConfigurationModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.CompilerOutputModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.ContentRootsModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.DependenciesModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.JavaFacetModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.JavaLanguageLevelModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.java.JavaModuleCleanupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaModuleModelDataService
extends ModuleModelDataService<JavaModuleModel> {
    @NotNull
    private final JavaModuleSetup myModuleSetup;
    @NotNull
    private final JavaModuleCleanupStep myCleanupStep;

    public JavaModuleModelDataService() {
        this(new JavaModuleSetup(new JavaFacetModuleSetupStep(), new ContentRootsModuleSetupStep(), new DependenciesModuleSetupStep(), new ArtifactsByConfigurationModuleSetupStep(), new CompilerOutputModuleSetupStep(), new JavaLanguageLevelModuleSetupStep()), new JavaModuleCleanupStep());
    }

    @VisibleForTesting
    JavaModuleModelDataService(@NotNull JavaModuleSetup moduleSetup, @NotNull JavaModuleCleanupStep cleanupStep) {
        this.myModuleSetup = moduleSetup;
        this.myCleanupStep = cleanupStep;
    }

    @NotNull
    public Key<JavaModuleModel> getTargetDataKey() {
        return AndroidProjectKeys.JAVA_MODULE_MODEL;
    }

    @Override
    protected void importData(@NotNull Collection<DataNode<JavaModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, JavaModuleModel> modelsByName) {
        boolean syncSkipped = GradleSyncState.getInstance(project).isSyncSkipped();
        for (Module module : modelsProvider.getModules()) {
            JavaModuleModel javaModuleModel = modelsByName.get(module.getName());
            if (javaModuleModel != null) {
                this.myModuleSetup.setUpModule(module, modelsProvider, javaModuleModel, null, null, syncSkipped);
                continue;
            }
            this.onModelNotFound(module, modelsProvider);
        }
    }

    @Override
    protected void onModelNotFound(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        this.myCleanupStep.cleanUpModule(module, modelsProvider);
    }
}

