/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.sync.idea.data.model.ImportedModule;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleDisposer;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDisposalDataService
extends AbstractProjectDataService<ImportedModule, Void> {
    @NotNull
    private final ModuleDisposer myModuleDisposer;

    public ModuleDisposalDataService() {
        this(new ModuleDisposer());
    }

    ModuleDisposalDataService(@NotNull ModuleDisposer moduleDisposer) {
        this.myModuleDisposer = moduleDisposer;
    }

    @NotNull
    public Key<ImportedModule> getTargetDataKey() {
        return AndroidProjectKeys.IMPORTED_MODULE;
    }

    public void importData(@NotNull Collection<DataNode<ImportedModule>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport.isEmpty() || !this.myModuleDisposer.canDisposeModules(project)) {
            return;
        }
        Module[] modules = modelsProvider.getModules();
        if (modules.length != toImport.size()) {
            HashMap<String, Module> modulesByName = new HashMap<String, Module>();
            for (Module module : modules) {
                modulesByName.put(module.getName(), module);
            }
            for (DataNode dataNode : toImport) {
                ImportedModule importedModule = (ImportedModule)dataNode.getData();
                modulesByName.remove(importedModule.getName());
            }
            ArrayList<Module> modulesToDispose = new ArrayList<Module>(modulesByName.values());
            this.myModuleDisposer.disposeModules(modulesToDispose, project, modelsProvider);
        }
    }
}

