/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.module.NdkModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.ndk.ContentRootModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.ndk.NdkFacetModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.ndk.NdkModuleCleanupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NdkModuleModelDataService
extends ModuleModelDataService<NdkModuleModel> {
    @NotNull
    private final NdkModuleSetup myModuleSetup;
    @NotNull
    private final NdkModuleCleanupStep myCleanupStep;

    public NdkModuleModelDataService() {
        this(new NdkModuleSetup(new NdkFacetModuleSetupStep(), new ContentRootModuleSetupStep()), new NdkModuleCleanupStep());
    }

    @VisibleForTesting
    NdkModuleModelDataService(@NotNull NdkModuleSetup moduleSetup, @NotNull NdkModuleCleanupStep cleanupStep) {
        this.myModuleSetup = moduleSetup;
        this.myCleanupStep = cleanupStep;
    }

    @NotNull
    public Key<NdkModuleModel> getTargetDataKey() {
        return AndroidProjectKeys.NDK_MODEL;
    }

    @Override
    protected void importData(@NotNull Collection<DataNode<NdkModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, NdkModuleModel> modelsByName) {
        boolean syncSkipped = GradleSyncState.getInstance(project).isSyncSkipped();
        for (Module module : modelsProvider.getModules()) {
            NdkModuleModel ndkModuleModel = modelsByName.get(module.getName());
            if (ndkModuleModel != null) {
                this.myModuleSetup.setUpModule(module, modelsProvider, ndkModuleModel, null, null, syncSkipped);
                continue;
            }
            this.onModelNotFound(module, modelsProvider);
        }
    }

    @Override
    protected void onModelNotFound(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        this.myCleanupStep.cleanUpModule(module, modelsProvider);
    }
}

