/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.notification;

import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.pom.NonNavigatable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleNotificationExtension
implements ExternalSystemNotificationExtension {
    @NotNull
    private final SyncErrorHandler[] myErrorHandlers;

    public GradleNotificationExtension() {
        this(SyncErrorHandler.getExtensions());
    }

    @VisibleForTesting
    GradleNotificationExtension(SyncErrorHandler ... errorHandlers) {
        this.myErrorHandlers = errorHandlers;
    }

    @NotNull
    public ProjectSystemId getTargetExternalSystemId() {
        return GradleUtil.GRADLE_SYSTEM_ID;
    }

    public void customize(@NotNull NotificationData notification, @NotNull Project project, @Nullable Throwable error) {
        GradleSyncMessages.getInstance(project).removeProjectMessages();
        Throwable cause = error;
        if (error instanceof UndeclaredThrowableException && (cause = ((UndeclaredThrowableException)error).getUndeclaredThrowable()) instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        if (cause instanceof ExternalSystemException) {
            this.handleError((ExternalSystemException)cause, notification, project);
        }
        if (notification.getNavigatable() == null) {
            notification.setNavigatable(NonNavigatable.INSTANCE);
        }
    }

    private void handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        for (SyncErrorHandler errorHandler : this.myErrorHandlers) {
            if (!errorHandler.handleError(error, notification, project)) continue;
            return;
        }
    }
}

