/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.project.sync.errors.SdkBuildToolsTooLowErrorHandler;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildToolsTooLowReporter
extends BaseSyncIssuesReporter {
    @NotNull
    private final SdkBuildToolsTooLowErrorHandler myErrorHandler;

    BuildToolsTooLowReporter() {
        this(SdkBuildToolsTooLowErrorHandler.getInstance());
    }

    @VisibleForTesting
    BuildToolsTooLowReporter(@NotNull SdkBuildToolsTooLowErrorHandler errorHandler) {
        this.myErrorHandler = errorHandler;
    }

    @Override
    int getSupportedIssueType() {
        return 13;
    }

    @Override
    void report(@NotNull SyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile) {
        String minimumVersion = syncIssue.getData();
        assert (minimumVersion != null);
        SyncMessage message = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, syncIssue.getMessage());
        List<NotificationHyperlink> quickFixes = this.myErrorHandler.getQuickFixHyperlinks(minimumVersion, module.getProject(), module);
        message.add(quickFixes);
        this.getSyncMessages(module).report(message);
    }
}

