/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NonNavigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UnhandledIssuesReporter
extends BaseSyncIssuesReporter {
    UnhandledIssuesReporter() {
    }

    @Override
    int getSupportedIssueType() {
        return -1;
    }

    @Override
    void report(@NotNull SyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile) {
        SyncMessage message;
        String group = "Gradle Sync Issues";
        String text = syncIssue.getMessage();
        MessageType type = UnhandledIssuesReporter.getMessageType(syncIssue);
        if (buildFile != null) {
            PositionInFile position = new PositionInFile(buildFile);
            message = new SyncMessage(module.getProject(), group, type, position, text);
        } else {
            message = new SyncMessage(group, type, NonNavigatable.INSTANCE, text);
        }
        this.getSyncMessages(module).report(message);
    }
}

