/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.model.util.GoogleMavenRepository;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.AddGoogleMavenRepositoryHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.DisableOfflineModeHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallArtifactHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallRepositoryHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowDependencyInProjectStructureHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowSyncIssuesDetailsHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.ConstraintLayoutFeature;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioSdkUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NonNavigatable;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class UnresolvedDependenciesReporter
extends BaseSyncIssuesReporter {
    private static final String UNRESOLVED_DEPENDENCIES_GROUP = "Unresolved dependencies";
    private static final String OPEN_FILE_HYPERLINK_TEXT = "Open File";

    @NotNull
    public static UnresolvedDependenciesReporter getInstance() {
        return (UnresolvedDependenciesReporter)ServiceManager.getService(UnresolvedDependenciesReporter.class);
    }

    @Override
    int getSupportedIssueType() {
        return 2;
    }

    @Override
    void report(@NotNull SyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile) {
        String dependency = syncIssue.getData();
        if (dependency != null) {
            this.report(dependency, module, buildFile);
        } else {
            this.reportWithoutDependencyInfo(syncIssue, module, buildFile);
        }
    }

    public void report(@NotNull Collection<String> unresolvedDependencies, @NotNull Module module) {
        if (unresolvedDependencies.isEmpty()) {
            return;
        }
        VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
        for (String dependency : unresolvedDependencies) {
            this.report(dependency, module, buildFile);
        }
        GradleSyncState.getInstance(module.getProject()).getSummary().setSyncErrorsFound(true);
    }

    private void report(@NotNull String dependency, @NotNull Module module, @Nullable VirtualFile buildFile) {
        SyncMessage message;
        String group = "Unresolved Android dependencies";
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)dependency);
        RepoPackage constraintPackage = null;
        if (coordinate != null) {
            StudioLoggerProgressIndicator indicator = new StudioLoggerProgressIndicator(this.getClass());
            StudioSdkUtil.reloadRemoteSdkWithModalProgress();
            Collection<RemotePackage> remotePackages = UnresolvedDependenciesReporter.getRemotePackages((ProgressIndicator)indicator);
            constraintPackage = SdkMavenRepository.findBestPackageMatching((GradleCoordinate)coordinate, remotePackages);
        }
        ArrayList<NotificationHyperlink> quickFixes = new ArrayList<NotificationHyperlink>();
        if (dependency.startsWith("com.android.support.constraint:constraint-layout:") && !ConstraintLayoutFeature.isSupportedInSdkManager(module)) {
            quickFixes.add(new FixAndroidGradlePluginVersionHyperlink());
        } else if (constraintPackage != null) {
            quickFixes.add(new InstallArtifactHyperlink(constraintPackage.getPath()));
        } else if (dependency.startsWith("com.android.support")) {
            UnresolvedDependenciesReporter.addGoogleMavenRepositoryHyperlink(module, buildFile, quickFixes);
        } else if (dependency.startsWith("com.google.android")) {
            quickFixes.add(new InstallRepositoryHyperlink(SdkMavenRepository.GOOGLE, dependency));
        } else {
            group = UNRESOLVED_DEPENDENCIES_GROUP;
            Project project = module.getProject();
            if (Projects.isOfflineBuildModeEnabled(project)) {
                quickFixes.add(new DisableOfflineModeHyperlink());
            }
        }
        String text = "Failed to resolve: " + dependency;
        if (buildFile != null) {
            PositionInFile position = UnresolvedDependenciesReporter.findDependencyPosition(dependency, buildFile);
            message = new SyncMessage(module.getProject(), group, MessageType.ERROR, position, text);
            String hyperlinkText = position.line > -1 ? "Show in File" : OPEN_FILE_HYPERLINK_TEXT;
            quickFixes.add(new OpenFileHyperlink(buildFile.getPath(), hyperlinkText, position.line, position.column));
        } else {
            message = new SyncMessage(group, MessageType.ERROR, NonNavigatable.INSTANCE, text);
        }
        if (IdeInfo.getInstance().isAndroidStudio() && coordinate != null) {
            quickFixes.add(new ShowDependencyInProjectStructureHyperlink(module, coordinate));
        }
        message.add(quickFixes);
        this.getSyncMessages(module).report(message);
    }

    @NotNull
    private static PositionInFile findDependencyPosition(@NotNull String dependency, @NotNull VirtualFile buildFile) {
        TextRange textRange;
        int line = -1;
        int column = -1;
        Document document = FileDocumentManager.getInstance().getDocument(buildFile);
        if (document != null && (textRange = UnresolvedDependenciesReporter.findDependency(dependency, document)) != null && (line = document.getLineNumber(textRange.getStartOffset())) > -1) {
            int lineStartOffset = document.getLineStartOffset(line);
            column = textRange.getStartOffset() - lineStartOffset;
        }
        return new PositionInFile(buildFile, line, column);
    }

    @NotNull
    private static Collection<RemotePackage> getRemotePackages(@NotNull ProgressIndicator indicator) {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        RepositoryPackages packages = sdkHandler.getSdkManager(indicator).getPackages();
        return packages.getRemotePackages().values();
    }

    @Nullable
    private static TextRange findDependency(@NotNull String dependency, @NotNull Document buildFile) {
        Function consumer = pair -> {
            GroovyLexer lexer = (GroovyLexer)pair.getSecond();
            return TextRange.create((int)(lexer.getTokenStart() + 1), (int)(lexer.getTokenEnd() - 1));
        };
        GroovyLexer lexer = new GroovyLexer();
        lexer.start((CharSequence)buildFile.getText());
        while (lexer.getTokenType() != null) {
            String text;
            IElementType type = lexer.getTokenType();
            if (type == GroovyTokenTypes.mSTRING_LITERAL && (text = StringUtil.unquoteString((String)lexer.getTokenText())).startsWith(dependency)) {
                return (TextRange)consumer.fun((Object)Pair.create((Object)text, (Object)lexer));
            }
            lexer.advance();
        }
        return null;
    }

    private void reportWithoutDependencyInfo(@NotNull SyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile) {
        SyncMessage message;
        String text = syncIssue.getMessage();
        ArrayList<NotificationHyperlink> quickFixes = new ArrayList<NotificationHyperlink>();
        if (buildFile != null) {
            PositionInFile position = new PositionInFile(buildFile, -1, 1);
            message = new SyncMessage(module.getProject(), UNRESOLVED_DEPENDENCIES_GROUP, MessageType.ERROR, position, text);
            quickFixes.add(new OpenFileHyperlink(buildFile.getPath(), OPEN_FILE_HYPERLINK_TEXT, position.line, position.column));
        } else {
            message = new SyncMessage(UNRESOLVED_DEPENDENCIES_GROUP, MessageType.ERROR, NonNavigatable.INSTANCE, text);
        }
        ArrayList<String> extraInfo = new ArrayList<String>();
        try {
            List multiLineMessage = syncIssue.getMultiLineMessage();
            if (multiLineMessage != null) {
                extraInfo.addAll(multiLineMessage);
            }
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            // empty catch block
        }
        if (!extraInfo.isEmpty()) {
            quickFixes.add(new ShowSyncIssuesDetailsHyperlink(text, extraInfo));
        }
        message.add(quickFixes);
        this.getSyncMessages(module).report(message);
    }

    private static void addGoogleMavenRepositoryHyperlink(@NotNull Module module, @Nullable VirtualFile buildFile, @NotNull List<NotificationHyperlink> fixes) {
        Project project = module.getProject();
        if (buildFile != null) {
            GradleBuildModel moduleBuildModel = GradleBuildModel.parseBuildFile(buildFile, project, module.getName());
            if (!GoogleMavenRepository.hasGoogleMavenRepository(moduleBuildModel.repositories())) {
                fixes.add(new AddGoogleMavenRepositoryHyperlink(buildFile));
            }
        } else {
            RepositoriesModel repositories;
            GradleBuildModel projectBuildModel = GradleBuildModel.get(project);
            if (projectBuildModel != null && !GoogleMavenRepository.hasGoogleMavenRepository(repositories = projectBuildModel.repositories())) {
                fixes.add(new AddGoogleMavenRepositoryHyperlink(projectBuildModel.getVirtualFile()));
            }
        }
    }
}

