/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.android.DependenciesAndroidModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidModuleValidator;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidModuleProcessor {
    static Key<SyncAction.ModuleModels> MODULE_GRADLE_MODELS_KEY = Key.create((String)"module.gradle.models");
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeModifiableModelsProvider myModelsProvider;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final AndroidModuleValidator.Factory myModuleValidatorFactory;
    @NotNull
    private final AndroidModuleSetup myAndroidModuleSetup;

    AndroidModuleProcessor(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        this(project, modelsProvider, GradleSyncState.getInstance(project), new AndroidModuleValidator.Factory(), new AndroidModuleSetup(new DependenciesAndroidModuleSetupStep()));
    }

    public AndroidModuleProcessor(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull GradleSyncState syncState, @NotNull AndroidModuleValidator.Factory moduleValidatorFactory, @NotNull AndroidModuleSetup moduleSetup) {
        this.myProject = project;
        this.myModelsProvider = modelsProvider;
        this.mySyncState = syncState;
        this.myModuleValidatorFactory = moduleValidatorFactory;
        this.myAndroidModuleSetup = moduleSetup;
    }

    void processAndroidModels(@NotNull List<Module> androidModules, @NotNull ProgressIndicator indicator) {
        AndroidModuleValidator moduleValidator = this.myModuleValidatorFactory.create(this.myProject);
        for (Module module : androidModules) {
            AndroidModuleModel androidModel = this.findAndroidModel(module);
            if (androidModel == null) continue;
            SyncAction.ModuleModels moduleModels = (SyncAction.ModuleModels)module.getUserData(MODULE_GRADLE_MODELS_KEY);
            assert (moduleModels != null);
            boolean syncSkipped = this.mySyncState.isSyncSkipped();
            this.myAndroidModuleSetup.setUpModule(module, this.myModelsProvider, androidModel, moduleModels, indicator, syncSkipped);
            moduleValidator.validate(module, androidModel);
        }
        moduleValidator.fixAndReportFoundIssues();
    }

    @Nullable
    private AndroidModuleModel findAndroidModel(@NotNull Module module) {
        AndroidFacet facet = Facets.findFacet(module, this.myModelsProvider, AndroidFacet.ID);
        return facet != null ? AndroidModuleModel.get(facet) : null;
    }
}

