/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.sync.GradleSync;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutor;
import com.android.tools.idea.gradle.project.sync.ng.SyncResultHandler;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewGradleSync
implements GradleSync {
    @NotNull
    private final Project myProject;
    @NotNull
    private final SyncExecutor mySyncExecutor;
    @NotNull
    private final SyncResultHandler myResultHandler;
    @NotNull
    private final SyncExecutionCallback.Factory myCallbackFactory;

    public static boolean isEnabled() {
        return NewGradleSync.isOptionVisible() && GradleExperimentalSettings.getInstance().USE_NEW_GRADLE_SYNC;
    }

    public static boolean isLevel4Model() {
        return NewGradleSync.isEnabled();
    }

    public static boolean isOptionVisible() {
        return SystemProperties.getBooleanProperty((String)"show.new.sync.preference", (boolean)false);
    }

    public NewGradleSync(@NotNull Project project) {
        this(project, new SyncExecutor(project), new SyncResultHandler(project), new SyncExecutionCallback.Factory());
    }

    @VisibleForTesting
    NewGradleSync(@NotNull Project project, @NotNull SyncExecutor syncExecutor, @NotNull SyncResultHandler resultHandler, @NotNull SyncExecutionCallback.Factory callbackFactory) {
        this.myProject = project;
        this.mySyncExecutor = syncExecutor;
        this.myResultHandler = resultHandler;
        this.myCallbackFactory = callbackFactory;
    }

    @Override
    public void sync(@NotNull GradleSyncInvoker.Request request, @Nullable GradleSyncListener listener) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.sync(listener, (ProgressIndicator)new EmptyProgressIndicator(), request.isNewOrImportedProject());
            return;
        }
        Task task = this.createSyncTask(request, listener);
        ApplicationManager.getApplication().invokeLater(() -> ((Task)task).queue(), ModalityState.defaultModalityState());
    }

    @VisibleForTesting
    @NotNull
    Task createSyncTask(@NotNull GradleSyncInvoker.Request request, final @Nullable GradleSyncListener listener) {
        String title = "Gradle Sync";
        ProgressExecutionMode executionMode = request.getProgressExecutionMode();
        final boolean isNewProject = request.isNewOrImportedProject();
        switch (executionMode) {
            case MODAL_SYNC: {
                return new Task.Modal(this.myProject, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        NewGradleSync.this.sync(listener, indicator, isNewProject);
                    }
                };
            }
            case IN_BACKGROUND_ASYNC: {
                return new Task.Backgroundable(this.myProject, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        NewGradleSync.this.sync(listener, indicator, isNewProject);
                    }
                };
            }
        }
        throw new IllegalArgumentException(executionMode + " is not a supported execution mode");
    }

    private void sync(@Nullable GradleSyncListener syncListener, @NotNull ProgressIndicator indicator, boolean isNewProject) {
        SyncExecutionCallback callback = this.myCallbackFactory.create();
        callback.doWhenDone(() -> this.myResultHandler.onSyncFinished(callback, indicator, syncListener, isNewProject)).doWhenRejected(() -> this.myResultHandler.onSyncFailed(callback, syncListener));
        this.mySyncExecutor.syncProject(indicator, callback);
    }
}

