/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.ng.AndroidModuleProcessor;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleDisposer;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

class ObsoleteModuleDisposer {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ModuleDisposer myModuleDisposer;
    @NotNull
    private final IdeModifiableModelsProvider myModelsProvider;

    ObsoleteModuleDisposer(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        this(project, modelsProvider, new ModuleDisposer());
    }

    ObsoleteModuleDisposer(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleDisposer moduleDisposer) {
        this.myProject = project;
        this.myModelsProvider = modelsProvider;
        this.myModuleDisposer = moduleDisposer;
    }

    void disposeObsoleteModules(@NotNull ProgressIndicator indicator) {
        if (!this.myModuleDisposer.canDisposeModules(this.myProject)) {
            return;
        }
        CopyOnWriteArrayList<Module> modulesToDispose = new CopyOnWriteArrayList<Module>();
        List<Module> modules = Arrays.asList(this.myModelsProvider.getModules());
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(modules, indicator, true, module -> {
            SyncAction.ModuleModels moduleModels = (SyncAction.ModuleModels)module.getUserData(AndroidModuleProcessor.MODULE_GRADLE_MODELS_KEY);
            if (moduleModels == null) {
                modulesToDispose.add((Module)module);
            } else {
                module.putUserData(AndroidModuleProcessor.MODULE_GRADLE_MODELS_KEY, null);
            }
            return true;
        });
        this.myModuleDisposer.disposeModules(modulesToDispose, this.myProject, this.myModelsProvider);
    }
}

