/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.ng.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

abstract class ProjectSetup {
    ProjectSetup() {
    }

    abstract void setUpProject(@NotNull SyncAction.ProjectModels var1, @NotNull ProgressIndicator var2);

    abstract void commit();

    @VisibleForTesting
    static class ProjectSetupImpl
    extends ProjectSetup {
        @NotNull
        private final Project myProject;
        @NotNull
        private final IdeModifiableModelsProvider myModelsProvider;
        @NotNull
        private final ModuleSetup.Factory myModuleSetupFactory;

        ProjectSetupImpl(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleSetup.Factory moduleSetupFactory) {
            this.myProject = project;
            this.myModelsProvider = modelsProvider;
            this.myModuleSetupFactory = moduleSetupFactory;
        }

        @Override
        void setUpProject(final @NotNull SyncAction.ProjectModels models, final @NotNull ProgressIndicator indicator) {
            final ModuleSetup moduleSetup = this.myModuleSetupFactory.create(this.myProject, this.myModelsProvider);
            try {
                ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                    public void execute() {
                        moduleSetup.setUpModules(models, indicator);
                    }
                });
            }
            catch (Throwable e) {
                this.disposeChanges();
                throw e;
            }
        }

        @Override
        void commit() {
            try {
                ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                    public void execute() {
                        myModelsProvider.commit();
                    }
                });
            }
            catch (Throwable e) {
                this.disposeChanges();
                throw e;
            }
        }

        private void disposeChanges() {
            ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                public void execute() {
                    myModelsProvider.dispose();
                }
            });
        }
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        ProjectSetup create(@NotNull Project project) {
            return new ProjectSetupImpl(project, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project), new ModuleSetup.Factory());
        }
    }
}

