/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.java.model.ArtifactModel;
import com.android.java.model.JavaProject;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncAction
implements BuildAction<ProjectModels>,
Serializable {
    @NotNull
    private final Set<Class<?>> myAndroidModelTypes;
    @NotNull
    private final Set<Class<?>> myJavaModelTypes;

    public SyncAction() {
        this(Collections.emptySet(), Collections.emptySet());
    }

    public SyncAction(@NotNull Set<Class<?>> androidModelTypes, @NotNull Set<Class<?>> javaModelTypes) {
        this.myAndroidModelTypes = androidModelTypes;
        this.myJavaModelTypes = javaModelTypes;
    }

    @Nullable
    public ProjectModels execute(@NotNull BuildController controller) {
        GradleBuild gradleBuild = controller.getBuildModel();
        ProjectModels models = new ProjectModels(this.myAndroidModelTypes, this.myJavaModelTypes);
        models.populate(gradleBuild, controller);
        return models;
    }

    public static class ModuleModels
    implements Serializable {
        @NotNull
        private final GradleProject myGradleProject;
        @NotNull
        private final Set<Class<?>> myAndroidModelTypes;
        @NotNull
        private final Set<Class<?>> myJavaModelTypes;
        @NotNull
        private final Map<Class, Object> myModelsByType = new HashMap<Class, Object>();

        public ModuleModels(@NotNull GradleProject gradleProject, @NotNull Set<Class<?>> androidModelTypes, @NotNull Set<Class<?>> javaModelTypes) {
            this.myGradleProject = gradleProject;
            this.myAndroidModelTypes = androidModelTypes;
            this.myJavaModelTypes = javaModelTypes;
        }

        public void populate(@NotNull GradleProject gradleProject, @NotNull BuildController controller) {
            this.myModelsByType.put(GradleProject.class, gradleProject);
            AndroidProject androidProject = this.findAndAddModel(gradleProject, controller, AndroidProject.class);
            if (androidProject != null) {
                for (Class<?> type : this.myAndroidModelTypes) {
                    this.findAndAddModel(gradleProject, controller, type);
                }
                return;
            }
            NativeAndroidProject ndkAndroidProject = this.findAndAddModel(gradleProject, controller, NativeAndroidProject.class);
            if (ndkAndroidProject != null) {
                return;
            }
            JavaProject javaProject = this.findAndAddModel(gradleProject, controller, JavaProject.class);
            if (javaProject != null) {
                for (Class<?> type : this.myJavaModelTypes) {
                    this.findAndAddModel(gradleProject, controller, type);
                }
                return;
            }
            this.findAndAddModel(gradleProject, controller, ArtifactModel.class);
        }

        @NotNull
        public String getGradlePath() {
            return this.myGradleProject.getPath();
        }

        @NotNull
        public String getModuleName() {
            return this.myGradleProject.getName();
        }

        @Nullable
        private <T> T findAndAddModel(@NotNull GradleProject gradleProject, @NotNull BuildController controller, Class<T> modelType) {
            Object model = controller.findModel((Model)gradleProject, modelType);
            if (model != null) {
                this.myModelsByType.put(modelType, model);
            }
            return (T)model;
        }

        public <T> boolean hasModel(@NotNull Class<T> modelType) {
            return this.findModel(modelType) != null;
        }

        @Nullable
        public <T> T findModel(@NotNull Class<T> modelType) {
            Object model = this.myModelsByType.get(modelType);
            if (model != null) {
                assert (modelType.isInstance(model));
                return modelType.cast(model);
            }
            return null;
        }
    }

    public static class ProjectModels
    implements Serializable {
        @NotNull
        private final Set<Class<?>> myAndroidModelTypes;
        @NotNull
        private final Set<Class<?>> myJavaModelTypes;
        @NotNull
        private final Map<String, ModuleModels> myModelsByModule = new HashMap<String, ModuleModels>();
        @Nullable
        private GlobalLibraryMap myGlobalLibraryMap;

        public ProjectModels(@NotNull Set<Class<?>> androidModelTypes, @NotNull Set<Class<?>> javaModelTypes) {
            this.myAndroidModelTypes = androidModelTypes;
            this.myJavaModelTypes = javaModelTypes;
        }

        public void populate(@NotNull GradleBuild gradleBuild, @NotNull BuildController controller) {
            BasicGradleProject rootProject = gradleBuild.getRootProject();
            GradleProject root = (GradleProject)controller.findModel((Model)rootProject, GradleProject.class);
            this.populateModels(root, controller);
            for (ModuleModels moduleModels : this.myModelsByModule.values()) {
                AndroidProject androidProject = moduleModels.findModel(AndroidProject.class);
                if (androidProject == null) continue;
                this.myGlobalLibraryMap = (GlobalLibraryMap)controller.findModel((Model)moduleModels.findModel(GradleProject.class), GlobalLibraryMap.class);
                break;
            }
        }

        private void populateModels(@NotNull GradleProject project, @NotNull BuildController controller) {
            ModuleModels models = new ModuleModels(project, this.myAndroidModelTypes, this.myJavaModelTypes);
            models.populate(project, controller);
            this.myModelsByModule.put(project.getPath(), models);
            for (GradleProject child : project.getChildren()) {
                this.populateModels(child, controller);
            }
        }

        @NotNull
        public Collection<String> getProjectPaths() {
            return this.myModelsByModule.keySet();
        }

        @Nullable
        public ModuleModels getModels(@NotNull String gradlePath) {
            return this.myModelsByModule.get(gradlePath);
        }

        @Nullable
        public GlobalLibraryMap getGlobalLibraryMap() {
            return this.myGlobalLibraryMap;
        }
    }
}

