/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandlerManager;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.ng.ExtraSyncModelExtensionManager;
import com.android.tools.idea.gradle.project.sync.ng.GradleSyncProgress;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

class SyncExecutor {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSyncMessages mySyncMessages;
    @NotNull
    private final CommandLineArgs myCommandLineArgs;
    @NotNull
    private final SyncErrorHandlerManager myErrorHandlerManager;
    @NotNull
    private final ExtraSyncModelExtensionManager myExtraSyncModelExtensionManager;
    @NotNull
    private final GradleExecutionHelper myHelper = new GradleExecutionHelper();

    SyncExecutor(@NotNull Project project) {
        this(project, GradleSyncMessages.getInstance(project), new CommandLineArgs(true), new SyncErrorHandlerManager(project), new ExtraSyncModelExtensionManager());
    }

    @VisibleForTesting
    SyncExecutor(@NotNull Project project, @NotNull GradleSyncMessages syncMessages, @NotNull CommandLineArgs commandLineArgs, @NotNull SyncErrorHandlerManager errorHandlerManager, @NotNull ExtraSyncModelExtensionManager extraSyncModelExtensionManager) {
        this.myProject = project;
        this.mySyncMessages = syncMessages;
        this.myCommandLineArgs = commandLineArgs;
        this.myErrorHandlerManager = errorHandlerManager;
        this.myExtraSyncModelExtensionManager = extraSyncModelExtensionManager;
    }

    void syncProject(@NotNull ProgressIndicator indicator, @NotNull SyncExecutionCallback callback) {
        Runnable removeMessagesTask = () -> this.mySyncMessages.removeMessages(new String[]{null});
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            removeMessagesTask.run();
        } else {
            application.invokeAndWait(removeMessagesTask);
        }
        if (this.myProject.isDisposed()) {
            callback.reject(String.format("Project '%1$s' is already disposed", this.myProject.getName()));
        }
        GradleExecutionSettings executionSettings = GradleUtil.getOrCreateGradleExecutionSettings(this.myProject);
        Function syncFunction = connection -> {
            SyncAction syncAction = new SyncAction(this.myExtraSyncModelExtensionManager.getExtraAndroidModels(), this.myExtraSyncModelExtensionManager.getExtraJavaModels());
            BuildActionExecuter executor = connection.action((BuildAction)syncAction);
            List<String> commandLineArgs = this.myCommandLineArgs.get(this.myProject);
            ExternalSystemTaskId id = SyncExecutor.createId(this.myProject);
            GradleExecutionHelper.prepare((LongRunningOperation)executor, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new GradleSyncNotificationListener(indicator), Collections.emptyList(), commandLineArgs, (ProjectConnection)connection);
            CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
            executor.withCancellationToken(cancellationTokenSource.token());
            try {
                SyncAction.ProjectModels models = (SyncAction.ProjectModels)executor.run();
                callback.setDone(models);
            }
            catch (RuntimeException e) {
                this.myErrorHandlerManager.handleError(e);
                callback.setRejected(e);
            }
            return null;
        };
        this.myHelper.execute(Projects.getBaseDirPath(this.myProject).getPath(), executionSettings, syncFunction);
    }

    @NotNull
    private static ExternalSystemTaskId createId(@NotNull Project project) {
        return ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)project);
    }

    @VisibleForTesting
    static class GradleSyncNotificationListener
    extends ExternalSystemTaskNotificationListenerAdapter {
        @NotNull
        private final ProgressIndicator myIndicator;

        GradleSyncNotificationListener(@NotNull ProgressIndicator indicator) {
            this.myIndicator = indicator;
        }

        public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
            GradleSyncProgress.notifyProgress(this.myIndicator, event.getDescription());
        }
    }
}

