/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ng.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SyncResultHandler {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final ProjectSetup.Factory myProjectSetupFactory;
    @NotNull
    private final PostSyncProjectSetup myPostSyncProjectSetup;

    SyncResultHandler(@NotNull Project project) {
        this(project, GradleSyncState.getInstance(project), new ProjectSetup.Factory(), PostSyncProjectSetup.getInstance(project));
    }

    @VisibleForTesting
    SyncResultHandler(@NotNull Project project, @NotNull GradleSyncState syncState, @NotNull ProjectSetup.Factory projectSetupFactory, @NotNull PostSyncProjectSetup postSyncProjectSetup) {
        this.myProject = project;
        this.mySyncState = syncState;
        this.myProjectSetupFactory = projectSetupFactory;
        this.myPostSyncProjectSetup = postSyncProjectSetup;
    }

    void onSyncFinished(@NotNull SyncExecutionCallback callback, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener, boolean isProjectNew) {
        block5: {
            SyncAction.ProjectModels models = callback.getModels();
            if (models != null) {
                try {
                    this.setUpProject(this.myProject, models, indicator, syncListener);
                    Runnable runnable = () -> {
                        boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
                        if (!(!isProjectNew || isTest && GradleProjectImporter.ourSkipSetupFromTest)) {
                            Projects.open(this.myProject);
                        }
                        if (!isTest) {
                            this.myProject.save();
                        }
                        if (isProjectNew) {
                            AndroidGradleProjectComponent projectComponent = AndroidGradleProjectComponent.getInstance(this.myProject);
                            projectComponent.configureGradleProject();
                        }
                    };
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        runnable.run();
                        break block5;
                    }
                    ExternalSystemUtil.invokeLater((Project)this.myProject, (Runnable)runnable);
                }
                catch (Throwable e) {
                    this.notifyAndLogSyncError(SyncResultHandler.nullToUnknownErrorCause(SyncResultHandler.getRootCauseMessage(e)), e, syncListener);
                }
            } else {
                this.notifyAndLogSyncError("Gradle did not return any project models", null, syncListener);
            }
        }
    }

    private void setUpProject(@NotNull Project project, @NotNull SyncAction.ProjectModels models, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        try {
            if (syncListener != null) {
                syncListener.setupStarted(project);
            }
            this.mySyncState.setupStarted();
            ProjectSetup projectSetup = this.myProjectSetupFactory.create(project);
            projectSetup.setUpProject(models, indicator);
            projectSetup.commit();
            if (syncListener != null) {
                syncListener.syncSucceeded(project);
            }
            PostSyncProjectSetup.Request request = new PostSyncProjectSetup.Request();
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> this.myPostSyncProjectSetup.setUpProject(request, indicator));
        }
        catch (Throwable e) {
            this.notifyAndLogSyncError(SyncResultHandler.nullToUnknownErrorCause(SyncResultHandler.getRootCauseMessage(e)), e, syncListener);
        }
    }

    void onSyncFailed(@NotNull SyncExecutionCallback callback, @Nullable GradleSyncListener syncListener) {
        Throwable error = callback.getSyncError();
        String errorMessage = error != null ? SyncResultHandler.getRootCauseMessage(error) : callback.getError();
        errorMessage = SyncResultHandler.nullToUnknownErrorCause(errorMessage);
        this.notifyAndLogSyncError(errorMessage, error, syncListener);
    }

    private void notifyAndLogSyncError(@NotNull String errorMessage, @Nullable Throwable error, @Nullable GradleSyncListener syncListener) {
        if (syncListener != null) {
            syncListener.syncFailed(this.myProject, errorMessage);
        }
        this.mySyncState.syncFailed(errorMessage);
        if (error != null) {
            SyncResultHandler.getLog().warn("Gradle sync failed", error);
        } else {
            SyncResultHandler.logSyncFailure(errorMessage);
        }
    }

    @Nullable
    private static String getRootCauseMessage(@NotNull Throwable error) {
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)error);
        String message = rootCause.getMessage();
        return StringUtil.isEmpty((String)message) ? rootCause.getClass().getName() : message;
    }

    @NotNull
    private static String nullToUnknownErrorCause(@Nullable String errorMessage) {
        return StringUtil.isEmpty((String)errorMessage) ? "<Unknown cause>" : errorMessage;
    }

    private static void logSyncFailure(@NotNull String errorMessage) {
        SyncResultHandler.getLog().warn("Gradle sync failed: " + errorMessage);
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(SyncResultHandler.class);
    }
}

