/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.precheck;

import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.precheck.AndroidStudioSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class JdkPreSyncCheck
extends AndroidStudioSyncCheck {
    JdkPreSyncCheck() {
    }

    @Override
    @NotNull
    PreSyncCheckResult doCheckCanSync(@NotNull Project project) {
        Sdk jdk = IdeSdks.getInstance().getJdk();
        if (!JdkPreSyncCheck.isValidJdk(jdk)) {
            String msg = "Please use JDK 8 or newer.";
            SyncMessage message = new SyncMessage("Project sync error", MessageType.ERROR, msg);
            List<NotificationHyperlink> quickFixes = Jdks.getInstance().getWrongJdkQuickFixes(project);
            message.add(quickFixes);
            GradleSyncMessages.getInstance(project).report(message);
            return PreSyncCheckResult.failure(msg);
        }
        return PreSyncCheckResult.SUCCESS;
    }

    private static boolean isValidJdk(Sdk jdk) {
        if (jdk == null) {
            return false;
        }
        String jdkHomePath = jdk.getHomePath();
        return jdkHomePath != null && JdkUtil.checkForJdk((File)new File(jdkHomePath)) && Jdks.getInstance().isApplicableJdk(jdk, LanguageLevel.JDK_1_8);
    }
}

