/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.tools.idea.gradle.util.FilePaths;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncLibraryRegistry
implements Disposable {
    @VisibleForTesting
    static final Key<SyncLibraryRegistry> KEY = Key.create((String)"com.android.tools.gradle.sync.ProjectLibraryRegistry");
    private static Factory ourFactory = new Factory();
    @Nullable
    private Project myProject;
    @NotNull
    private final Map<String, Library> myProjectLibrariesByName = new HashMap<String, Library>();
    @NotNull
    private final Set<LibraryToUpdate> myLibrariesToUpdate = new HashSet<LibraryToUpdate>();

    public static void replaceForTesting(@NotNull Project project, @Nullable SyncLibraryRegistry libraryRegistry) {
        project.putUserData(KEY, (Object)libraryRegistry);
    }

    @NotNull
    public static SyncLibraryRegistry getInstance(@NotNull Project project) {
        SyncLibraryRegistry registry = (SyncLibraryRegistry)project.getUserData(KEY);
        if (registry == null || registry.isDisposed()) {
            registry = ourFactory.createNewInstance(project);
            project.putUserData(KEY, (Object)registry);
        }
        return registry;
    }

    SyncLibraryRegistry(@NotNull Project project) {
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
        this.registerExistingLibraries();
    }

    private void registerExistingLibraries() {
        LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)this.myProject);
        for (Library library : libraryTable.getLibraries()) {
            String name = library.getName();
            if (name == null) continue;
            this.myProjectLibrariesByName.put(name, library);
        }
    }

    public void markAsUsed(@NotNull Library library, File ... newBinaryPaths) {
        Library used;
        this.checkNotDisposed();
        String name = library.getName();
        if (name != null && (used = this.myProjectLibrariesByName.remove(name)) != null) {
            ArrayList existingBinaryUrls = Lists.newArrayList((Object[])used.getUrls(OrderRootType.CLASSES));
            boolean urlCountChanged = newBinaryPaths.length != existingBinaryUrls.size();
            ArrayList<String> newBinaryUrls = new ArrayList<String>();
            for (File newBinaryPath : newBinaryPaths) {
                String newBinaryUrl = FilePaths.pathToIdeaUrl(newBinaryPath);
                existingBinaryUrls.remove(newBinaryUrl);
                newBinaryUrls.add(newBinaryUrl);
            }
            if (!existingBinaryUrls.isEmpty() || urlCountChanged) {
                LibraryToUpdate libraryToUpdate = new LibraryToUpdate(used, newBinaryUrls);
                this.myLibrariesToUpdate.add(libraryToUpdate);
            }
        }
    }

    @NotNull
    public Collection<Library> getLibrariesToRemove() {
        this.checkNotDisposed();
        return this.myProjectLibrariesByName.values();
    }

    @NotNull
    public List<LibraryToUpdate> getLibrariesToUpdate() {
        this.checkNotDisposed();
        return ImmutableList.copyOf(this.myLibrariesToUpdate);
    }

    private void checkNotDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Already disposed");
        }
    }

    @VisibleForTesting
    boolean isDisposed() {
        return Disposer.isDisposed((Disposable)this);
    }

    public void dispose() {
        assert (this.myProject != null);
        this.myProject.putUserData(KEY, null);
        this.myProject = null;
        this.myProjectLibrariesByName.clear();
        this.myLibrariesToUpdate.clear();
    }

    @NotNull
    Map<String, Library> getProjectLibrariesByName() {
        return this.myProjectLibrariesByName;
    }

    public static void restoreFactory() {
        SyncLibraryRegistry.setFactory(new Factory());
    }

    public static void setFactory(@NotNull Factory factory) {
        ourFactory = factory;
    }

    public static class LibraryToUpdate {
        @NotNull
        private final Library myLibrary;
        @NotNull
        private final Collection<String> myNewBinaryUrls;

        @VisibleForTesting
        public LibraryToUpdate(@NotNull Library library, @NotNull Collection<String> newBinaryUrls) {
            this.myLibrary = library;
            this.myNewBinaryUrls = newBinaryUrls;
        }

        @NotNull
        public Library getLibrary() {
            return this.myLibrary;
        }

        @NotNull
        public Collection<String> getNewBinaryUrls() {
            return this.myNewBinaryUrls;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LibraryToUpdate update = (LibraryToUpdate)o;
            return Objects.equals(this.myLibrary.getName(), update.myLibrary.getName()) && Objects.equals(this.myNewBinaryUrls, update.myNewBinaryUrls);
        }

        public int hashCode() {
            return Objects.hash(this.myLibrary.getName(), this.myNewBinaryUrls);
        }
    }

    @VisibleForTesting
    public static class Factory {
        @NotNull
        public SyncLibraryRegistry createNewInstance(@NotNull Project project) {
            return new SyncLibraryRegistry(project);
        }
    }
}

