/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.gradle.util.FilePaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerSettingsSetup {
    public void setOutputPaths(@NotNull ModifiableRootModel moduleModel, @NotNull File mainOutputPath, @Nullable File testOutputPath) {
        CompilerModuleExtension compilerSettings = (CompilerModuleExtension)moduleModel.getModuleExtension(CompilerModuleExtension.class);
        if (compilerSettings == null) {
            String msg = String.format("No compiler extension is found for module '%1$s'", moduleModel.getModule().getName());
            Logger.getInstance(this.getClass()).warn(msg);
            return;
        }
        compilerSettings.inheritCompilerOutputPath(false);
        compilerSettings.setCompilerOutputPath(FilePaths.pathToIdeaUrl(mainOutputPath));
        if (testOutputPath != null) {
            compilerSettings.setCompilerOutputPathForTests(FilePaths.pathToIdeaUrl(testOutputPath));
        }
    }
}

