/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.gradle.project.sync.setup.module.common.RootSourceFolder;
import com.android.tools.idea.gradle.util.ContentEntries;
import com.android.tools.idea.gradle.util.FilePaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class ContentEntriesSetup {
    @NotNull
    private final ModifiableRootModel myModuleModel;
    @NotNull
    private final List<RootSourceFolder> myOrphans = new ArrayList<RootSourceFolder>();

    protected ContentEntriesSetup(@NotNull ModifiableRootModel moduleModel) {
        this.myModuleModel = moduleModel;
    }

    public static void removeExistingContentEntries(@NotNull ModifiableRootModel rootModel) {
        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
            rootModel.removeContentEntry(contentEntry);
        }
    }

    public abstract void execute(@NotNull List<ContentEntry> var1);

    protected void addSourceFolder(@NotNull File folderPath, @NotNull Collection<ContentEntry> contentEntries, @NotNull JpsModuleSourceRootType type, boolean generated) {
        ContentEntry parent = ContentEntries.findParentContentEntry(folderPath, contentEntries.stream());
        if (parent == null) {
            this.myOrphans.add(new RootSourceFolder(folderPath, type, generated));
            return;
        }
        ContentEntriesSetup.addSourceFolder(parent, folderPath, type, generated);
    }

    private static void addSourceFolder(@NotNull ContentEntry contentEntry, @NotNull File folderPath, @NotNull JpsModuleSourceRootType type, boolean generated) {
        JpsModuleSourceRoot sourceRoot;
        JpsElement properties;
        String url = FilePaths.pathToIdeaUrl(folderPath);
        SourceFolder sourceFolder = contentEntry.addSourceFolder(url, type);
        if (generated && (properties = (sourceRoot = sourceFolder.getJpsElement()).getProperties()) instanceof JavaSourceRootProperties) {
            ((JavaSourceRootProperties)properties).setForGeneratedSources(true);
        }
    }

    protected boolean addExcludedFolder(@NotNull ContentEntry contentEntry, @NotNull File folderPath) {
        if (!ContentEntries.isPathInContentEntry(folderPath, contentEntry)) {
            return false;
        }
        contentEntry.addExcludeFolder(FilePaths.pathToIdeaUrl(folderPath));
        return true;
    }

    protected void addOrphans() {
        for (RootSourceFolder orphan : this.myOrphans) {
            File path = orphan.getPath();
            ContentEntry contentEntry = this.myModuleModel.addContentEntry(FilePaths.pathToIdeaUrl(path));
            ContentEntriesSetup.addSourceFolder(contentEntry, path, orphan.getType(), orphan.isGenerated());
        }
    }

    @NotNull
    protected Module getModule() {
        return this.myModuleModel.getModule();
    }
}

