/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.builder.model.level2.Library;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeDependencies;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class DependenciesExtractor {
    @NotNull
    public static DependenciesExtractor getInstance() {
        return (DependenciesExtractor)ServiceManager.getService(DependenciesExtractor.class);
    }

    @NotNull
    public DependencySet extractFrom(@NotNull IdeVariant variant) {
        DependencySet dependencies2 = new DependencySet();
        for (IdeBaseArtifact testArtifact : variant.getTestArtifacts()) {
            DependenciesExtractor.populate(dependencies2, testArtifact, DependencyScope.TEST);
        }
        IdeAndroidArtifact mainArtifact = variant.getMainArtifact();
        DependenciesExtractor.populate(dependencies2, mainArtifact, DependencyScope.COMPILE);
        return dependencies2;
    }

    @NotNull
    public DependencySet extractFrom(@NotNull IdeBaseArtifact artifact, @NotNull DependencyScope scope) {
        DependencySet dependencies2 = new DependencySet();
        DependenciesExtractor.populate(dependencies2, artifact, scope);
        return dependencies2;
    }

    private static void populate(@NotNull DependencySet dependencies2, @NotNull IdeBaseArtifact artifact, @NotNull DependencyScope scope) {
        IdeDependencies artifactDependencies = artifact.getLevel2Dependencies();
        for (Library library : artifactDependencies.getJavaLibraries()) {
            LibraryDependency libraryDependency = new LibraryDependency(library.getArtifact(), library.getArtifactAddress(), scope);
            libraryDependency.addPath(LibraryDependency.PathType.BINARY, library.getArtifact());
            dependencies2.add(libraryDependency);
        }
        for (Library library : artifactDependencies.getAndroidLibraries()) {
            dependencies2.add(DependenciesExtractor.createLibraryDependencyFromAndroidLibrary(library, scope));
        }
        for (Library library : artifactDependencies.getModuleDependencies()) {
            String gradleProjectPath = library.getProjectPath();
            if (gradleProjectPath == null || gradleProjectPath.isEmpty()) continue;
            ModuleDependency dependency = new ModuleDependency(gradleProjectPath, scope);
            dependencies2.add(dependency);
        }
    }

    @NotNull
    private static LibraryDependency createLibraryDependencyFromAndroidLibrary(@NotNull Library library, @NotNull DependencyScope scope) {
        LibraryDependency dependency = new LibraryDependency(library.getArtifact(), DependenciesExtractor.getDependencyName(library, "-"), scope);
        dependency.addPath(LibraryDependency.PathType.BINARY, library.getJarFile());
        dependency.addPath(LibraryDependency.PathType.BINARY, library.getResFolder());
        for (String localJar : library.getLocalJars()) {
            dependency.addPath(LibraryDependency.PathType.BINARY, localJar);
        }
        return dependency;
    }

    @NotNull
    public static String getDependencyName(@NotNull Library library, @NotNull String separator) {
        String artifactAddress = library.getArtifactAddress();
        GradleCoordinate coordinates = GradleCoordinate.parseCoordinateString((String)artifactAddress);
        if (coordinates != null) {
            String name = coordinates.getArtifactId();
            GradleVersion version = coordinates.getVersion();
            if (version != null && !"unspecified".equals(version.toString())) {
                name = name + separator + version;
            }
            assert (name != null);
            if (StringUtil.isNotEmpty((String)coordinates.getGroupId())) {
                return coordinates.getGroupId() + ":" + name;
            }
            return name;
        }
        return StringUtil.trimLeading((String)artifactAddress, (char)':');
    }

    @NotNull
    public static String getDependencyDisplayName(@NotNull Library library) {
        String artifactAddress = library.getArtifactAddress();
        GradleCoordinate coordinates = GradleCoordinate.parseCoordinateString((String)artifactAddress);
        if (coordinates != null) {
            GradleVersion version;
            int index;
            String groupSuffix;
            String groupId;
            String name = coordinates.getArtifactId();
            if (name == null) {
                name = "?";
            }
            if (!name.contains("-") && (groupId = coordinates.getGroupId()) != null && !(groupSuffix = groupId.substring((index = groupId.lastIndexOf(46)) + 1)).equals(name)) {
                name = groupSuffix + ":" + name;
            }
            if ((version = coordinates.getVersion()) != null && !"unspecified".equals(version.toString())) {
                name = name + ":" + version;
            }
            return name;
        }
        return StringUtil.trimLeading((String)artifactAddress, (char)':');
    }
}

