/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.google.common.collect.Lists;
import com.intellij.openapi.roots.DependencyScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class Dependency {
    static final List<DependencyScope> SUPPORTED_SCOPES = Lists.newArrayList((Object[])new DependencyScope[]{DependencyScope.COMPILE, DependencyScope.TEST});
    @NotNull
    private DependencyScope myScope;

    Dependency() {
        this(DependencyScope.COMPILE);
    }

    Dependency(@NotNull DependencyScope scope) throws IllegalArgumentException {
        this.setScope(scope);
    }

    @NotNull
    public final DependencyScope getScope() {
        return this.myScope;
    }

    void setScope(@NotNull DependencyScope scope) throws IllegalArgumentException {
        if (!SUPPORTED_SCOPES.contains(scope)) {
            String msg = String.format("'%1$s' is not a supported scope. Supported scopes are %2$s.", scope, SUPPORTED_SCOPES);
            throw new IllegalArgumentException(msg);
        }
        this.myScope = scope;
    }
}

