/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.tools.idea.gradle.project.sync.setup.module.dependency.Dependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DependencySet {
    @NotNull
    public static DependencySet EMPTY = new DependencySet();
    private final Multimap<String, LibraryDependency> myLibrariesByName = ArrayListMultimap.create();
    private final Map<String, ModuleDependency> myModulesByPath = Maps.newHashMap();

    DependencySet() {
    }

    void add(@NotNull LibraryDependency dependency) {
        String originalName = dependency.getName();
        Collection allStored = this.myLibrariesByName.get((Object)originalName);
        Object object = allStored = allStored == null ? null : ImmutableSet.copyOf((Collection)allStored);
        if (allStored == null || allStored.isEmpty()) {
            this.myLibrariesByName.put((Object)originalName, (Object)dependency);
            return;
        }
        LibraryDependency toAdd = dependency;
        LibraryDependency replaced = null;
        for (LibraryDependency stored : allStored) {
            if (!DependencySet.areSameArtifact(dependency, stored)) continue;
            toAdd = null;
            if (!DependencySet.hasHigherScope(dependency, stored)) break;
            replaced = stored;
            dependency.setName(stored.getName());
            this.myLibrariesByName.put((Object)originalName, (Object)dependency);
            break;
        }
        if (replaced != null) {
            this.myLibrariesByName.remove((Object)originalName, replaced);
        }
        if (toAdd != null) {
            String newName = allStored.size() + "_" + dependency.getName();
            dependency.setName(newName);
            this.myLibrariesByName.put((Object)originalName, (Object)dependency);
        }
    }

    public void addAll(DependencySet other) {
        for (LibraryDependency libraryDependency : other.onLibraries()) {
            this.add(libraryDependency);
        }
        for (ModuleDependency moduleDependency : other.onModules()) {
            this.add(moduleDependency);
        }
    }

    private static boolean areSameArtifact(@NotNull LibraryDependency d1, @NotNull LibraryDependency d2) {
        return Arrays.equals(d1.getPaths(LibraryDependency.PathType.BINARY), d2.getPaths(LibraryDependency.PathType.BINARY));
    }

    void add(@NotNull ModuleDependency dependency) {
        String gradlePath = dependency.getGradlePath();
        Dependency storedDependency = this.myModulesByPath.get(gradlePath);
        if (storedDependency == null || DependencySet.hasHigherScope(dependency, storedDependency)) {
            this.myModulesByPath.put(gradlePath, dependency);
        }
    }

    private static <T extends Dependency> boolean hasHigherScope(T d1, T d2) {
        return Dependency.SUPPORTED_SCOPES.indexOf(d1.getScope()) < Dependency.SUPPORTED_SCOPES.indexOf(d2.getScope());
    }

    @NotNull
    public ImmutableCollection<LibraryDependency> onLibraries() {
        return ImmutableSet.copyOf((Collection)this.myLibrariesByName.values());
    }

    @NotNull
    public ImmutableCollection<ModuleDependency> onModules() {
        return ImmutableSet.copyOf(this.myModulesByPath.values());
    }
}

