/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.tools.idea.gradle.LibraryFilePaths;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.Dependency;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class LibraryDependency
extends Dependency {
    @NotNull
    private final Map<PathType, Collection<File>> myPathsByType = new EnumMap<PathType, Collection<File>>(PathType.class);
    @NotNull
    private final File myArtifactPath;
    private String myName;

    @VisibleForTesting
    public LibraryDependency(@NotNull File artifactPath, @NotNull DependencyScope scope) {
        this(artifactPath, FileUtil.getNameWithoutExtension((File)artifactPath), scope);
        this.addPath(PathType.BINARY, artifactPath);
    }

    LibraryDependency(@NotNull File artifactPath, @NotNull String name, @NotNull DependencyScope scope) {
        super(scope);
        this.myArtifactPath = artifactPath;
        this.setName(name);
        LibraryFilePaths libraryFilePaths = LibraryFilePaths.getInstance();
        File javadocJarPath = libraryFilePaths.findJavadocJarPath(artifactPath);
        if (javadocJarPath != null) {
            this.addPath(PathType.DOCUMENTATION, javadocJarPath);
        }
    }

    @VisibleForTesting
    public void addPath(@NotNull PathType type, @NotNull File path) {
        Collection<File> paths = this.myPathsByType.get((Object)type);
        if (paths == null) {
            paths = new HashSet<File>();
            this.myPathsByType.put(type, paths);
        }
        paths.add(path);
    }

    void addPath(@NotNull PathType type, @NotNull String path) {
        this.addPath(type, new File(path));
    }

    @NotNull
    public File[] getPaths(@NotNull PathType type) {
        Collection<File> paths = this.myPathsByType.get((Object)type);
        return paths == null || paths.isEmpty() ? ArrayUtilRt.EMPTY_FILE_ARRAY : paths.toArray(new File[paths.size()]);
    }

    @NotNull
    public File getArtifactPath() {
        return this.myArtifactPath;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    void setName(@NotNull String name) {
        this.myName = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryDependency)) {
            return false;
        }
        LibraryDependency that = (LibraryDependency)o;
        return Objects.equals(this.myPathsByType, that.myPathsByType) && Objects.equals(this.myArtifactPath, that.myArtifactPath) && Objects.equals(this.myName, that.myName);
    }

    public int hashCode() {
        return Objects.hash(this.myPathsByType, this.myArtifactPath, this.myName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name='" + this.myName + '\'' + ", scope=" + this.getScope() + ", pathsByType=" + this.myPathsByType + "]";
    }

    public static enum PathType {
        BINARY,
        DOCUMENTATION;

    }
}

