/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.idea.java;

import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.module.common.CompilerSettingsSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;

public class CompilerOutputModuleSetupStep
extends JavaModuleSetupStep {
    @NonNls
    private static final String CLASSES_FOLDER_NAME = "classes";
    @NotNull
    private final CompilerSettingsSetup myCompilerSettingsSetup;

    public CompilerOutputModuleSetupStep() {
        this(new CompilerSettingsSetup());
    }

    @VisibleForTesting
    CompilerOutputModuleSetupStep(@NotNull CompilerSettingsSetup compilerSettingsSetup) {
        this.myCompilerSettingsSetup = compilerSettingsSetup;
    }

    @Override
    protected void doSetUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull JavaModuleModel javaModuleModel, @Nullable SyncAction.ModuleModels gradleModels, @Nullable ProgressIndicator indicator) {
        File mainClassesFolderPath = null;
        File testClassesFolderPath = null;
        ExtIdeaCompilerOutput compilerOutput = javaModuleModel.getCompilerOutput();
        if (compilerOutput != null) {
            mainClassesFolderPath = compilerOutput.getMainClassesDir();
            testClassesFolderPath = compilerOutput.getTestClassesDir();
        }
        if (javaModuleModel.isBuildable()) {
            File buildFolderPath = javaModuleModel.getBuildFolderPath();
            if (mainClassesFolderPath == null) {
                mainClassesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, "main"}));
            }
            if (testClassesFolderPath == null) {
                testClassesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, "test"}));
            }
        }
        if (mainClassesFolderPath != null) {
            ModifiableRootModel moduleModel = ideModelsProvider.getModifiableRootModel(module);
            this.myCompilerSettingsSetup.setOutputPaths(moduleModel, mainClassesFolderPath, testClassesFolderPath);
        }
    }

    @Override
    public boolean invokeOnSkippedSync() {
        return true;
    }
}

