/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.idea.java;

import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.module.common.ContentEntriesSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.JavaContentEntriesSetup;
import com.android.tools.idea.gradle.util.FilePaths;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentRootsModuleSetupStep
extends JavaModuleSetupStep {
    @Override
    protected void doSetUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull JavaModuleModel javaModuleModel, @Nullable SyncAction.ModuleModels gradleModels, @Nullable ProgressIndicator indicator) {
        ModifiableRootModel moduleModel = ideModelsProvider.getModifiableRootModel(module);
        JavaContentEntriesSetup setup = new JavaContentEntriesSetup(javaModuleModel, moduleModel);
        List<ContentEntry> contentEntries = ContentRootsModuleSetupStep.findContentEntries(moduleModel, javaModuleModel);
        setup.execute(contentEntries);
    }

    @NotNull
    private static List<ContentEntry> findContentEntries(@NotNull ModifiableRootModel moduleModel, @NotNull JavaModuleModel javaModuleModel) {
        ContentEntriesSetup.removeExistingContentEntries(moduleModel);
        ArrayList<ContentEntry> contentEntries = new ArrayList<ContentEntry>();
        for (JavaModuleContentRoot contentRoot : javaModuleModel.getContentRoots()) {
            File rootDirPath = contentRoot.getRootDirPath();
            ContentEntry contentEntry = moduleModel.addContentEntry(FilePaths.pathToIdeaUrl(rootDirPath));
            contentEntries.add(contentEntry);
        }
        return contentEntries;
    }

    @Override
    public boolean invokeOnSkippedSync() {
        return true;
    }
}

