/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgradeStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class PluginVersionUpgrade {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PluginVersionUpgradeStep[] myUpgradeSteps;

    @NotNull
    public static PluginVersionUpgrade getInstance(@NotNull Project project) {
        return (PluginVersionUpgrade)ServiceManager.getService((Project)project, PluginVersionUpgrade.class);
    }

    public PluginVersionUpgrade(@NotNull Project project) {
        this(project, PluginVersionUpgradeStep.getExtensions());
    }

    @VisibleForTesting
    PluginVersionUpgrade(@NotNull Project project, PluginVersionUpgradeStep ... upgradeSteps) {
        this.myProject = project;
        this.myUpgradeSteps = upgradeSteps;
    }

    public boolean checkAndPerformUpgrade() {
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(this.myProject);
        if (pluginInfo == null) {
            PluginVersionUpgrade.getLog().warn("Unable to obtain application's Android Project");
            return false;
        }
        PluginVersionUpgrade.log(pluginInfo);
        for (PluginVersionUpgradeStep upgradeStep : this.myUpgradeSteps) {
            if (!upgradeStep.checkAndPerformUpgrade(this.myProject, pluginInfo)) continue;
            return true;
        }
        return false;
    }

    private static void log(@NotNull AndroidPluginInfo pluginInfo) {
        GradleVersion current = pluginInfo.getPluginVersion();
        String recommended = pluginInfo.getPluginGeneration().getLatestKnownVersion();
        String message = String.format("Gradle model version: %1$s, recommended version for IDE: %2$s", current, recommended);
        PluginVersionUpgrade.getLog().info(message);
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(PluginVersionUpgrade.class);
    }
}

