/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.builder.model.SyncIssue;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.GradleProjectSyncData;
import com.android.tools.idea.gradle.project.SupportedModuleChecker;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.compatibility.VersionCompatibilityChecker;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.module.common.DependencySetupIssues;
import com.android.tools.idea.gradle.project.sync.setup.post.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgrade;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectStructureUsageTracker;
import com.android.tools.idea.gradle.project.sync.setup.post.project.DisposedModules;
import com.android.tools.idea.gradle.project.sync.validation.common.CommonModuleValidator;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.profiles.ProjectProfileSelectionDialog;
import com.android.tools.idea.instantapp.ProvistionTasks;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationType;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.concurrency.JobLauncher;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class PostSyncProjectSetup {
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final GradleSyncInvoker mySyncInvoker;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final DependencySetupIssues myDependencySetupIssues;
    @NotNull
    private final ProjectSetup myProjectSetup;
    @NotNull
    private final ModuleSetup myModuleSetup;
    @NotNull
    private final PluginVersionUpgrade myPluginVersionUpgrade;
    @NotNull
    private final VersionCompatibilityChecker myVersionCompatibilityChecker;
    @NotNull
    private final GradleProjectBuilder myProjectBuilder;
    @NotNull
    private final CommonModuleValidator.Factory myModuleValidatorFactory;
    @NotNull
    private final RunManagerImpl myRunManager;
    @NotNull
    private final ProvistionTasks myProvistionTasks;

    @NotNull
    public static PostSyncProjectSetup getInstance(@NotNull Project project) {
        return (PostSyncProjectSetup)ServiceManager.getService((Project)project, PostSyncProjectSetup.class);
    }

    public PostSyncProjectSetup(@NotNull Project project, @NotNull IdeInfo ideInfo, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleSyncState syncState, @NotNull GradleSyncMessages syncMessages, @NotNull DependencySetupIssues dependencySetupIssues, @NotNull PluginVersionUpgrade pluginVersionUpgrade, @NotNull VersionCompatibilityChecker versionCompatibilityChecker, @NotNull GradleProjectBuilder projectBuilder) {
        this(project, ideInfo, gradleProjectInfo, syncInvoker, syncState, dependencySetupIssues, new ProjectSetup(project), new ModuleSetup(project), pluginVersionUpgrade, versionCompatibilityChecker, projectBuilder, new CommonModuleValidator.Factory(), RunManagerImpl.getInstanceImpl((Project)project), new ProvistionTasks());
    }

    @VisibleForTesting
    PostSyncProjectSetup(@NotNull Project project, @NotNull IdeInfo ideInfo, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleSyncState syncState, @NotNull DependencySetupIssues dependencySetupIssues, @NotNull ProjectSetup projectSetup, @NotNull ModuleSetup moduleSetup, @NotNull PluginVersionUpgrade pluginVersionUpgrade, @NotNull VersionCompatibilityChecker versionCompatibilityChecker, @NotNull GradleProjectBuilder projectBuilder, @NotNull CommonModuleValidator.Factory moduleValidatorFactory, @NotNull RunManagerImpl runManager, @NotNull ProvistionTasks provistionTasks) {
        this.myProject = project;
        this.myIdeInfo = ideInfo;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.mySyncInvoker = syncInvoker;
        this.mySyncState = syncState;
        this.myDependencySetupIssues = dependencySetupIssues;
        this.myProjectSetup = projectSetup;
        this.myModuleSetup = moduleSetup;
        this.myPluginVersionUpgrade = pluginVersionUpgrade;
        this.myVersionCompatibilityChecker = versionCompatibilityChecker;
        this.myProjectBuilder = projectBuilder;
        this.myModuleValidatorFactory = moduleValidatorFactory;
        this.myRunManager = runManager;
        this.myProvistionTasks = provistionTasks;
    }

    public void setUpProject(@NotNull Request request, @NotNull ProgressIndicator progressIndicator) {
        this.myGradleProjectInfo.setNewOrImportedProject(false);
        boolean syncFailed = this.mySyncState.lastSyncFailedOrHasIssues();
        if (syncFailed && request.isUsingCachedGradleModels()) {
            this.onCachedModelsSetupFailure(request);
            return;
        }
        this.myDependencySetupIssues.reportIssues();
        this.myVersionCompatibilityChecker.checkAndReportComponentIncompatibilities(this.myProject);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<Module> modules = Arrays.asList(moduleManager.getModules());
        CommonModuleValidator moduleValidator = this.myModuleValidatorFactory.create(this.myProject);
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(modules, progressIndicator, true, module -> {
            moduleValidator.validate((Module)module);
            return true;
        });
        moduleValidator.fixAndReportFoundIssues();
        if (syncFailed) {
            this.failTestsIfSyncIssuesPresent();
            this.myProjectSetup.setUpProject(progressIndicator, true);
            this.mySyncState.syncFailed("");
            return;
        }
        if (!request.isSkipAndroidPluginUpgrade() && this.myPluginVersionUpgrade.checkAndPerformUpgrade()) {
            return;
        }
        new ProjectStructureUsageTracker(this.myProject).trackProjectStructure();
        DisposedModules.getInstance(this.myProject).deleteImlFilesForDisposedModules();
        SupportedModuleChecker.getInstance().checkForSupportedModules(this.myProject);
        this.findAndShowVariantConflicts();
        this.myProjectSetup.setUpProject(progressIndicator, false);
        boolean androidStudio = this.myIdeInfo.isAndroidStudio();
        String taskName = androidStudio ? "Gradle-aware Make" : ExecutionBundle.message((String)"before.launch.compile.step", (Object[])new Object[0]);
        this.setMakeStepInJunitRunConfigurations(taskName);
        this.myProvistionTasks.addInstantAppProvisionTaskToRunConfigurations(this.myProject);
        this.notifySyncFinished(request);
        this.attemptToGenerateSources(request);
        TemplateManager.getInstance().refreshDynamicTemplateMenu(this.myProject);
        this.myModuleSetup.setUpModules(null);
    }

    public void onCachedModelsSetupFailure(@NotNull Request request) {
        long syncTimestamp = request.getLastSyncTimestamp();
        if (syncTimestamp < 0L) {
            syncTimestamp = System.currentTimeMillis();
        }
        this.mySyncState.syncSkipped(syncTimestamp);
        this.mySyncInvoker.requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_LOADED, null);
    }

    private void failTestsIfSyncIssuesPresent() {
        if (ApplicationManager.getApplication().isUnitTestMode() && this.mySyncState.getSummary().hasSyncErrors()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Sync issues found!").append('\n');
            this.myGradleProjectInfo.forEachAndroidModule((Consumer<AndroidFacet>)((Consumer)facet -> {
                Collection<SyncIssue> issues;
                AndroidModel androidModel = facet.getAndroidModel();
                if (androidModel instanceof AndroidModuleModel && (issues = ((AndroidModuleModel)androidModel).getSyncIssues()) != null && !issues.isEmpty()) {
                    buffer.append("Module '").append(facet.getModule().getName()).append("':").append('\n');
                    for (SyncIssue issue2 : issues) {
                        buffer.append(issue2.getMessage()).append('\n');
                    }
                }
            }));
            throw new IllegalStateException(buffer.toString());
        }
    }

    private void notifySyncFinished(@NotNull Request request) {
        if (request.isUsingCachedGradleModels()) {
            long timestamp = System.currentTimeMillis();
            this.mySyncState.syncSkipped(timestamp);
            GradleBuildState.getInstance(this.myProject).buildFinished(BuildStatus.SKIPPED);
        } else {
            this.mySyncState.syncEnded();
            GradleProjectSyncData.save(this.myProject);
        }
    }

    private void findAndShowVariantConflicts() {
        ConflictSet conflicts = ConflictSet.findConflicts(this.myProject);
        List<Conflict> structureConflicts = conflicts.getStructureConflicts();
        if (!structureConflicts.isEmpty() && SystemProperties.getBooleanProperty((String)"enable.project.profiles", (boolean)false)) {
            ProjectProfileSelectionDialog dialog = new ProjectProfileSelectionDialog(this.myProject, structureConflicts);
            dialog.show();
        }
        conflicts.showSelectionConflicts();
    }

    /*
     * WARNING - void declaration
     */
    private void setMakeStepInJunitRunConfigurations(@NotNull String makeTaskName) {
        AndroidJUnitConfigurationType junitConfigurationType = AndroidJUnitConfigurationType.getInstance();
        BeforeRunTaskProvider[] taskProviders = (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myProject);
        BeforeRunTaskProvider targetProvider = null;
        for (BeforeRunTaskProvider beforeRunTaskProvider : taskProviders) {
            if (!makeTaskName.equals(beforeRunTaskProvider.getName())) continue;
            targetProvider = beforeRunTaskProvider;
            break;
        }
        if (targetProvider != null) {
            void var8_13;
            RunConfiguration[] junitRunConfigurations;
            for (BeforeRunTaskProvider beforeRunTaskProvider : junitConfigurationType.getConfigurationFactories()) {
                RunnerAndConfigurationSettings template = this.myRunManager.getConfigurationTemplate((ConfigurationFactory)beforeRunTaskProvider);
                RunConfiguration runConfiguration = template.getConfiguration();
                this.setMakeStepInJUnitConfiguration(targetProvider, runConfiguration);
            }
            RunConfiguration[] runConfigurationArray = junitRunConfigurations = this.myRunManager.getConfigurations((ConfigurationType)junitConfigurationType);
            int n = runConfigurationArray.length;
            boolean bl = false;
            while (var8_13 < n) {
                RunConfiguration runConfiguration = runConfigurationArray[var8_13];
                this.setMakeStepInJUnitConfiguration(targetProvider, runConfiguration);
                ++var8_13;
            }
        }
    }

    private void setMakeStepInJUnitConfiguration(@NotNull BeforeRunTaskProvider targetProvider, @NotNull RunConfiguration runConfiguration) {
        LinkedList<BeforeRunTask> newBeforeRunTasks = new LinkedList<BeforeRunTask>();
        for (BeforeRunTask beforeRunTask : this.myRunManager.getBeforeRunTasks(runConfiguration)) {
            if (beforeRunTask.getProviderId().equals((Object)CompileStepBeforeRun.ID)) {
                BeforeRunTask task = targetProvider.createTask(runConfiguration);
                if (task == null) continue;
                task.setEnabled(true);
                newBeforeRunTasks.add(task);
                continue;
            }
            newBeforeRunTasks.add(beforeRunTask);
        }
        this.myRunManager.setBeforeRunTasks(runConfiguration, newBeforeRunTasks, false);
    }

    private void attemptToGenerateSources(@NotNull Request request) {
        if (!request.isGenerateSourcesAfterSync()) {
            return;
        }
        boolean cleanProjectAfterSync = request.isCleanProjectAfterSync();
        if (!cleanProjectAfterSync) {
            Map<String, GradleVersion> previousPluginVersionsPerModule = Projects.getPluginVersionsPerModule(this.myProject);
            Projects.storePluginVersionsPerModule(this.myProject);
            if (previousPluginVersionsPerModule != null && !previousPluginVersionsPerModule.isEmpty()) {
                Map<String, GradleVersion> currentPluginVersionsPerModule = Projects.getPluginVersionsPerModule(this.myProject);
                assert (currentPluginVersionsPerModule != null);
                for (Map.Entry<String, GradleVersion> entry : currentPluginVersionsPerModule.entrySet()) {
                    String modulePath = entry.getKey();
                    GradleVersion previous = previousPluginVersionsPerModule.get(modulePath);
                    if (previous != null && entry.getValue().compareTo(previous) == 0) continue;
                    cleanProjectAfterSync = true;
                    break;
                }
            }
        }
        if (cleanProjectAfterSync) {
            this.myProjectBuilder.cleanAndGenerateSources();
            return;
        }
        this.myProjectBuilder.generateSources();
    }

    public static class Request {
        @NotNull
        public static final Request DEFAULT_REQUEST = new Request(){

            @Override
            @NotNull
            public Request setCleanProjectAfterSync(boolean cleanProjectAfterSync) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public Request setGenerateSourcesAfterSync(boolean generateSourcesAfterSync) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public Request setLastSyncTimestamp(long lastSyncTimestamp) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public Request setUsingCachedGradleModels(boolean usingCachedGradleModels) {
                throw new UnsupportedOperationException();
            }
        };
        private boolean myUsingCachedGradleModels;
        private boolean myCleanProjectAfterSync;
        private boolean myGenerateSourcesAfterSync = true;
        private boolean mySkipAndroidPluginUpgrade;
        private long myLastSyncTimestamp = -1L;

        public boolean isUsingCachedGradleModels() {
            return this.myUsingCachedGradleModels;
        }

        @NotNull
        public Request setUsingCachedGradleModels(boolean usingCachedGradleModels) {
            this.myUsingCachedGradleModels = usingCachedGradleModels;
            return this;
        }

        public boolean isCleanProjectAfterSync() {
            return this.myCleanProjectAfterSync;
        }

        @NotNull
        public Request setCleanProjectAfterSync(boolean cleanProjectAfterSync) {
            this.myCleanProjectAfterSync = cleanProjectAfterSync;
            return this;
        }

        public boolean isGenerateSourcesAfterSync() {
            return this.myGenerateSourcesAfterSync;
        }

        @NotNull
        public Request setGenerateSourcesAfterSync(boolean generateSourcesAfterSync) {
            this.myGenerateSourcesAfterSync = generateSourcesAfterSync;
            return this;
        }

        public long getLastSyncTimestamp() {
            return this.myLastSyncTimestamp;
        }

        public boolean isSkipAndroidPluginUpgrade() {
            return this.mySkipAndroidPluginUpgrade;
        }

        public void setSkipAndroidPluginUpgrade() {
            this.mySkipAndroidPluginUpgrade = true;
        }

        @NotNull
        public Request setLastSyncTimestamp(long lastSyncTimestamp) {
            this.myLastSyncTimestamp = lastSyncTimestamp;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.myUsingCachedGradleModels == request.myUsingCachedGradleModels && this.myCleanProjectAfterSync == request.myCleanProjectAfterSync && this.myGenerateSourcesAfterSync == request.myGenerateSourcesAfterSync && this.myLastSyncTimestamp == request.myLastSyncTimestamp;
        }

        public int hashCode() {
            return Objects.hash(this.myUsingCachedGradleModels, this.myCleanProjectAfterSync, this.myGenerateSourcesAfterSync, this.myLastSyncTimestamp);
        }
    }
}

