/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSetup {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSetupStep[] mySetupSteps;

    public ProjectSetup(@NotNull Project project) {
        this(project, ProjectSetupStep.getExtensions());
    }

    @VisibleForTesting
    ProjectSetup(@NotNull Project project, ProjectSetupStep ... setupSteps) {
        this.myProject = project;
        this.mySetupSteps = setupSteps;
    }

    public void setUpProject(@Nullable ProgressIndicator progressIndicator, boolean syncFailed) {
        Runnable invokeProjectSetupStepsTask = () -> {
            for (ProjectSetupStep step : this.mySetupSteps) {
                if (syncFailed && !step.invokeOnFailedSync()) continue;
                step.setUpProject(this.myProject, progressIndicator);
            }
        };
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            invokeProjectSetupStepsTask.run();
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> ApplicationManager.getApplication().runWriteAction(invokeProjectSetupStepsTask));
    }
}

