/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidProject;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeDependencies;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleAndroidModule;
import com.google.wireless.android.sdk.stats.GradleBuildDetails;
import com.google.wireless.android.sdk.stats.GradleLibrary;
import com.google.wireless.android.sdk.stats.GradleModule;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureUsageTracker {
    private static final Logger LOG = Logger.getInstance(ProjectStructureUsageTracker.class);
    @NotNull
    private final Project myProject;

    ProjectStructureUsageTracker(@NotNull Project project) {
        this.myProject = project;
    }

    void trackProjectStructure() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            try {
                this.trackProjectStructure(moduleManager.getModules());
            }
            catch (Throwable e) {
                LOG.warn("Failed to track project structure", e);
            }
        });
    }

    void trackProjectStructure(@NotNull Module[] modules) {
        AndroidModuleModel model;
        AndroidModuleModel appModel = null;
        AndroidModuleModel libModel = null;
        int appCount = 0;
        int libCount = 0;
        ArrayList<GradleLibrary> gradleLibraries = new ArrayList<GradleLibrary>();
        for (Module module : modules) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null) continue;
            if (androidModel.getAndroidProject().getProjectType() == 1) {
                libModel = androidModel;
                ++libCount;
                continue;
            }
            appModel = androidModel;
            ++appCount;
            GradleLibrary gradleLibrary = ProjectStructureUsageTracker.trackExternalDependenciesInAndroidApp(androidModel);
            if (gradleLibrary == null) continue;
            gradleLibraries.add(gradleLibrary);
        }
        AndroidModuleModel androidModuleModel = model = appModel != null ? appModel : libModel;
        if (model != null) {
            ArrayList<GradleAndroidModule> gradleAndroidModules = new ArrayList<GradleAndroidModule>();
            ArrayList<GradleNativeAndroidModule> gradleNativeAndroidModules = new ArrayList<GradleNativeAndroidModule>();
            String appId = AnonymizerUtil.anonymizeUtf8((String)model.getApplicationId());
            IdeAndroidProject androidProject = model.getAndroidProject();
            GradleVersion gradleVersion = GradleVersions.getInstance().getGradleVersion(this.myProject);
            if (gradleVersion == null) {
                gradleVersion = new GradleVersion(0, 0, 0);
            }
            GradleModule gradleModule = GradleModule.newBuilder().setTotalModuleCount((long)modules.length).setAppModuleCount((long)appCount).setLibModuleCount((long)libCount).build();
            for (Module module : modules) {
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                if (androidModel != null) {
                    IdeAndroidProject moduleAndroidProject = androidModel.getAndroidProject();
                    GradleAndroidModule.Builder androidModule = GradleAndroidModule.newBuilder();
                    androidModule.setModuleName(AnonymizerUtil.anonymizeUtf8((String)module.getName())).setSigningConfigCount((long)moduleAndroidProject.getSigningConfigs().size()).setIsLibrary(moduleAndroidProject.getProjectType() == 1).setBuildTypeCount((long)androidModel.getBuildTypeNames().size()).setFlavorCount((long)androidModel.getProductFlavorNames().size()).setFlavorDimension((long)moduleAndroidProject.getFlavorDimensions().size());
                    gradleAndroidModules.add(androidModule.build());
                }
                boolean shouldReportNative = false;
                NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
                GradleNativeAndroidModule.NativeBuildSystemType buildSystemType = GradleNativeAndroidModule.NativeBuildSystemType.UNKNOWN_NATIVE_BUILD_SYSTEM_TYPE;
                String moduleName = "";
                if (ndkModuleModel != null) {
                    shouldReportNative = true;
                    if (ndkModuleModel.modelVersionIsAtLeast("2.2.0")) {
                        for (String buildSystem : ndkModuleModel.getAndroidProject().getBuildSystems()) {
                            buildSystemType = ProjectStructureUsageTracker.stringToBuildSystemType(buildSystem);
                        }
                    } else {
                        buildSystemType = GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL;
                    }
                    moduleName = AnonymizerUtil.anonymizeUtf8((String)ndkModuleModel.getModuleName());
                } else if (androidModel != null && ProjectStructureUsageTracker.areNativeLibrariesPresent(androidModel.getAndroidProject())) {
                    shouldReportNative = true;
                    buildSystemType = AndroidPluginGeneration.find(module) == AndroidPluginGeneration.COMPONENT ? GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL : GradleNativeAndroidModule.NativeBuildSystemType.NDK_COMPILE;
                }
                if (!shouldReportNative) continue;
                GradleNativeAndroidModule.Builder nativeModule = GradleNativeAndroidModule.newBuilder();
                nativeModule.setModuleName(moduleName).setBuildSystemType(buildSystemType);
                gradleNativeAndroidModules.add(nativeModule.build());
            }
            GradleBuildDetails.Builder gradleBuild = GradleBuildDetails.newBuilder();
            gradleBuild.setAppId(appId).setAndroidPluginVersion(androidProject.getModelVersion()).setGradleVersion(gradleVersion.toString()).setUserEnabledIr(InstantRunSettings.isInstantRunEnabled()).setModelSupportsIr(InstantRunGradleUtils.modelSupportsInstantRun(model)).setVariantSupportsIr(InstantRunGradleUtils.variantSupportsInstantRun(model)).addAllLibraries(gradleLibraries).addModules(gradleModule).addAllAndroidModules(gradleAndroidModules).addAllNativeAndroidModules(gradleNativeAndroidModules);
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
            event.setCategory(AndroidStudioEvent.EventCategory.GRADLE).setKind(AndroidStudioEvent.EventKind.GRADLE_BUILD_DETAILS).setGradleBuildDetails(gradleBuild);
            UsageTracker.getInstance().log(event);
        }
    }

    static GradleNativeAndroidModule.NativeBuildSystemType stringToBuildSystemType(@NotNull String buildSystem) {
        switch (buildSystem) {
            case "ndkBuild": {
                return GradleNativeAndroidModule.NativeBuildSystemType.NDK_BUILD;
            }
            case "cmake": {
                return GradleNativeAndroidModule.NativeBuildSystemType.CMAKE;
            }
            case "ndkCompile": {
                return GradleNativeAndroidModule.NativeBuildSystemType.NDK_COMPILE;
            }
            case "gradle": {
                return GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL;
            }
        }
        return GradleNativeAndroidModule.NativeBuildSystemType.UNKNOWN_NATIVE_BUILD_SYSTEM_TYPE;
    }

    private static boolean areNativeLibrariesPresent(@NotNull AndroidProject androidProject) {
        String modelVersion = androidProject.getModelVersion();
        if (modelVersion.startsWith("1.0") || modelVersion.startsWith("1.1") || androidProject.getApiVersion() < 3) {
            return false;
        }
        for (Variant variant : androidProject.getVariants()) {
            Collection nativeLibraries = variant.getMainArtifact().getNativeLibraries();
            if (nativeLibraries == null || nativeLibraries.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static GradleLibrary trackExternalDependenciesInAndroidApp(@NotNull AndroidModuleModel model) {
        IdeAndroidProject androidProject = model.getAndroidProject();
        Ref chosenVariant = new Ref();
        androidProject.forEachVariant(variant -> {
            if ("release".equals(variant.getBuildType())) {
                chosenVariant.set(variant);
            }
        });
        if (chosenVariant.get() == null) {
            chosenVariant.set((Object)model.getSelectedVariant());
        }
        IdeDependencies dependencies2 = ((IdeVariant)chosenVariant.get()).getMainArtifact().getLevel2Dependencies();
        return GradleLibrary.newBuilder().setAarDependencyCount((long)dependencies2.getAndroidLibraries().size()).setJarDependencyCount((long)dependencies2.getJavaLibraries().size()).build();
    }

    @Nullable
    public static String getApplicationId(@NotNull Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null || androidModel.getAndroidProject().getProjectType() != 0) continue;
            return androidModel.getApplicationId();
        }
        return null;
    }
}

