/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.cleanup;

import com.android.tools.idea.gradle.project.sync.setup.module.SyncLibraryRegistry;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectCleanupStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryCleanupStep
extends ProjectCleanupStep {
    @Override
    public void cleanUpProject(@NotNull Project project, @NotNull IdeModifiableModelsProvider ideModelsProvider, @Nullable ProgressIndicator indicator) {
        SyncLibraryRegistry libraryRegistry = SyncLibraryRegistry.getInstance(project);
        for (Library library : libraryRegistry.getLibrariesToRemove()) {
            ideModelsProvider.removeLibrary(library);
        }
        for (SyncLibraryRegistry.LibraryToUpdate libraryToUpdate : libraryRegistry.getLibrariesToUpdate()) {
            Library library = libraryToUpdate.getLibrary();
            Library.ModifiableModel libraryModel = ideModelsProvider.getModifiableLibraryModel(library);
            for (String existingBinaryUrl : libraryModel.getUrls(OrderRootType.CLASSES)) {
                libraryModel.removeRoot(existingBinaryUrl, OrderRootType.CLASSES);
            }
            for (String newBinaryUrl : libraryToUpdate.getNewBinaryUrls()) {
                libraryModel.addRoot(newBinaryUrl, OrderRootType.CLASSES);
            }
        }
        Disposer.dispose((Disposable)libraryRegistry);
    }
}

