/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DisposedModules
implements Disposable {
    @VisibleForTesting
    static final Key<DisposedModules> KEY = Key.create((String)"com.android.tools.gradle.sync.DisposedModules");
    @NotNull
    private final List<File> myFilesToDelete = new ArrayList<File>();
    private static Factory ourFactory = new Factory();

    @NotNull
    public static DisposedModules getInstance(@NotNull Project project) {
        DisposedModules disposedModules = (DisposedModules)project.getUserData(KEY);
        if (disposedModules == null || disposedModules.isDisposed()) {
            disposedModules = ourFactory.createNewInstance();
            project.putUserData(KEY, (Object)disposedModules);
        }
        return disposedModules;
    }

    public void markImlFilesForDeletion(@NotNull List<File> filesToDelete) {
        this.checkNotDisposed();
        this.myFilesToDelete.clear();
        if (!filesToDelete.isEmpty()) {
            this.myFilesToDelete.addAll(filesToDelete);
        }
    }

    public void deleteImlFilesForDisposedModules() {
        this.checkNotDisposed();
        for (File imlFile : this.myFilesToDelete) {
            boolean deleted;
            if (!imlFile.isFile() || (deleted = FileUtil.delete((File)imlFile))) continue;
            Logger.getInstance(DisposedModules.class).info("Failed to delete '" + imlFile.getPath() + "'");
        }
        Disposer.dispose((Disposable)this);
    }

    private void checkNotDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Already disposed");
        }
    }

    @VisibleForTesting
    boolean isDisposed() {
        return Disposer.isDisposed((Disposable)this);
    }

    public void dispose() {
        this.myFilesToDelete.clear();
    }

    @VisibleForTesting
    @NotNull
    List<File> getFilesToDelete() {
        return this.myFilesToDelete;
    }

    public static void restoreFactory() {
        DisposedModules.setFactory(new Factory());
    }

    public static void setFactory(@NotNull Factory factory) {
        ourFactory = factory;
    }

    @VisibleForTesting
    public static class Factory {
        @NotNull
        public DisposedModules createNewInstance() {
            return new DisposedModules();
        }
    }
}

