/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.build.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkSetupStep
extends ProjectSetupStep {
    @NotNull
    private final IdeSdks myIdeSdks;
    @NotNull
    private final Jdks myJdks;
    @NotNull
    private final IdeInfo myIdeInfo;

    public ProjectJdkSetupStep() {
        this(IdeSdks.getInstance(), Jdks.getInstance(), IdeInfo.getInstance());
    }

    @VisibleForTesting
    ProjectJdkSetupStep(@NotNull IdeSdks ideSdks, @NotNull Jdks jdks, @NotNull IdeInfo ideInfo) {
        this.myIdeSdks = ideSdks;
        this.myJdks = jdks;
        this.myIdeInfo = ideInfo;
    }

    @Override
    public void setUpProject(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        LanguageLevel javaLangVersion = LanguageLevel.JDK_1_8;
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Sdk ideJdk = null;
        Application application = ApplicationManager.getApplication();
        boolean androidStudio = this.myIdeInfo.isAndroidStudio();
        ideJdk = androidStudio ? this.myIdeSdks.getJdk() : (projectJdk == null || !this.myJdks.isApplicableJdk(projectJdk, javaLangVersion) ? this.myJdks.chooseOrCreateJavaSdk(javaLangVersion) : projectJdk);
        if (ideJdk == null) {
            SyncMessage message = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, "Unable to find a JDK");
            if (androidStudio) {
                message.add(this.myJdks.getWrongJdkQuickFixes(project));
            }
            GradleSyncMessages.getInstance(project).report(message);
            GradleSyncState.getInstance(project).getSummary().setSyncErrorsFound(true);
            return;
        }
        String homePath = ideJdk.getHomePath();
        if (homePath != null) {
            Sdk jdk = ideJdk;
            Runnable task = () -> application.runWriteAction(() -> this.myJdks.setJdk(project, jdk));
            TransactionGuard.submitTransaction((Disposable)project, (Runnable)task);
            PostProjectBuildTasksExecutor.getInstance(project).updateJavaLangLevelAfterBuild();
        }
    }

    @Override
    public boolean invokeOnFailedSync() {
        return true;
    }
}

